% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spades-functions.R
\name{wrap}
\alias{wrap}
\alias{wrap,ANY-method}
\title{Wrap coordinates or pixels in a torus-like fashion}
\usage{
wrap(obj, bounds, withHeading)

\S4method{wrap}{ANY}(obj, bounds, withHeading)
}
\arguments{
\item{obj}{A \verb{SpatialPoints*} object, or matrix of coordinates.}

\item{bounds}{Either a \verb{Raster*}, \code{Extent}, or \code{bbox} object
defining bounds to wrap around.}

\item{withHeading}{Logical. If \code{TRUE}, then the previous points must be
wrapped also so that the subsequent heading calculation will work.
Default \code{FALSE}. See details.}
}
\value{
Same class as \code{obj}, but with coordinates updated to reflect the wrapping.
}
\description{
Generally for model development purposes.
}
\details{
If \code{withHeading} used, then obj must be a \code{SpatialPointsDataFrame}
that contains two columns, \code{x1} and \code{y1}, with the immediately previous
agent locations.
}
\examples{
if (requireNamespace("terra")) {
  xrange <- yrange <- c(-50, 50)
  hab <- terra::rast(terra::ext(c(xrange, yrange)))
  hab[] <- runif(terra::ncell(hab))

  # initialize agents
  N <- 10

  # previous points
  x1 <- rep(0, N)
  y1 <- rep(0, N)
  # initial points
  starts <- cbind(
    x = stats::runif(N, xrange[1], xrange[2]),
    y = stats::runif(N, yrange[1], yrange[2])
  )

  # create the agent object
  agent <- agentMatrix(coords = starts, data = data.frame(x1 = x1, y1 = y1))

  ln <- rlnorm(N, 1, 0.02) # log normal step length
  sd <- 30 # could be specified globally in params

  if (interactive()) {
    library(quickPlot)
    clearPlot()
    Plot(hab, zero.color = "white", axes = "L")
    Plot(agent, addTo = "hab")
  }
  if (requireNamespace("SpaDES.tools") &&
    requireNamespace("CircStats")) {
    for (i in 1:10) {
      agent <- SpaDES.tools::crw(
        agent = agent,
        extent = terra::ext(hab), stepLength = ln,
        stddev = sd, lonlat = FALSE, torus = TRUE
      )
      if (interactive()) Plot(agent, addTo = "hab", axes = TRUE)
    }
  }
}
}
\author{
Eliot McIntire
}
