% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spades-functions.R
\docType{methods}
\name{wrap}
\alias{wrap}
\alias{wrap,matrix,Extent,missing-method}
\alias{wrap,SpatialPoints,ANY,missing-method}
\alias{wrap,matrix,Raster,missing-method}
\alias{wrap,matrix,Raster,missing-method}
\alias{wrap,matrix,matrix,missing-method}
\alias{wrap,SpatialPointsDataFrame,Extent,logical-method}
\alias{wrap,SpatialPointsDataFrame,Raster,logical-method}
\alias{wrap,SpatialPointsDataFrame,matrix,logical-method}
\title{Wrap coordinates or pixels in a torus-like fashion}
\usage{
wrap(obj, bounds, withHeading)

\S4method{wrap}{matrix,Extent,missing}(obj, bounds)

\S4method{wrap}{SpatialPoints,ANY,missing}(obj, bounds)

\S4method{wrap}{matrix,Raster,missing}(obj, bounds)

\S4method{wrap}{matrix,Raster,missing}(obj, bounds)

\S4method{wrap}{matrix,matrix,missing}(obj, bounds)

\S4method{wrap}{SpatialPointsDataFrame,Extent,logical}(obj, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,Raster,logical}(obj, bounds, withHeading)

\S4method{wrap}{SpatialPointsDataFrame,matrix,logical}(obj, bounds, withHeading)
}
\arguments{
\item{obj}{A \code{SpatialPoints*} object, or matrix of coordinates.}

\item{bounds}{Either a \code{Raster*}, \code{Extent}, or \code{bbox} object
defining bounds to wrap around.}

\item{withHeading}{Logical. If \code{TRUE}, then the previous points must be
wrapped also so that the subsequent heading calculation will work.
Default \code{FALSE}. See details.}
}
\value{
Same class as \code{obj}, but with coordinates updated to reflect the wrapping.
}
\description{
Generally for model development purposes.
}
\details{
If \code{withHeading} used, then obj must be a \code{SpatialPointsDataFrame}
that contains two columns, \code{x1} and \code{y1}, with the immediately previous
agent locations.
}
\examples{
library(quickPlot)
library(raster)

xrange <- yrange <- c(-50, 50)
hab <- raster(extent(c(xrange, yrange)))
hab[] <- 0

# initialize agents
N <- 10

# previous points
x1 <- rep(0, N)
y1 <- rep(0, N)
# initial points
starts <- cbind(x = stats::runif(N, xrange[1], xrange[2]),
                y = stats::runif(N, yrange[1], yrange[2]))

# create the agent object
agent <- SpatialPointsDataFrame(coords = starts, data = data.frame(x1, y1))


ln <- rlnorm(N, 1, 0.02) # log normal step length
sd <- 30 # could be specified globally in params

if (interactive()) {
  clearPlot()
  Plot(hab, zero.color = "white", axes = "L")
}
if (requireNamespace("SpaDES.tools")) {
  for (i in 1:10) {

    agent <- SpaDES.tools::crw(agent = agent,
                               extent = extent(hab), stepLength = ln,
                               stddev = sd, lonlat = FALSE, torus = TRUE)
   if (interactive()) Plot(agent, addTo = "hab", axes = TRUE)
 }
}
}
\author{
Eliot McIntire
}
