% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPMGibbsSkewT_parallel.R
\name{DPMGibbsSkewT_parallel}
\alias{DPMGibbsSkewT_parallel}
\title{Slice Sampling of Dirichlet Process Mixture of skew  Students's t-distibutions}
\usage{
DPMGibbsSkewT_parallel(Ncpus, type_connec, z, hyperG0, a, b, N,
  doPlot = FALSE, nbclust_init = 30, plotevery = N/10, diagVar = TRUE,
  verbose = FALSE, monitorfile = "", ...)
}
\arguments{
\item{Ncpus}{the number of processors available}

\item{type_connec}{The type of connection between the processors. Supported
cluster types are \code{"SOCK"}, \code{"FORK"}, \code{"MPI"}, and
\code{"NWS"}. See also \code{\link[parallel:makeCluster]{makeCluster}}.}

\item{z}{data matrix \code{d x n} with \code{d} dimensions in rows
and \code{n} observations in columns.}

\item{hyperG0}{prior mixing distribution.}

\item{a}{shape hyperparameter of the Gamma prior
on the parameter of the Dirichlet Process.}

\item{b}{scale hyperparameter of the Gamma prior
on the parameter of the Dirichlet Process.}

\item{N}{number of MCMC iterations.}

\item{doPlot}{logical flag indicating wether to plot MCMC iteration or not.
Default to \code{TRUE}.}

\item{nbclust_init}{number of clusters at initialisation.
Default to 30 (or less if there are less than 30 observations).}

\item{plotevery}{an integer indicating the interval between plotted iterations when \code{doPlot}
is \code{TRUE}.}

\item{diagVar}{logical flag indicating wether the variance of each cluster is
estimated as a diagonal matrix, or as a full matrix.
Default is \code{TRUE} (diagonal variance).}

\item{verbose}{logical flag indicating wether partition info is
written in the console at each MCMC iteration.}

\item{monitorfile}{a writable \link{connections} or a character string naming a file to write into,
to monitor the progress of the analysis.
Default is \code{""} which is no monitoring. See Details.}

\item{...}{additional arguments to be passed to \code{\link{plot_DPMst}}.
Only used if \code{doPlot} is \code{TRUE}.}
}
\value{
a object of class \code{DPMclust} with the following attributes:
 \itemize{
     \item{\code{mcmc_partitions}:}{a list of length \code{N}. Each
      element \code{mcmc_partitions[n]} is a vector of length
      \code{n} giving the partition of the \code{n} observations.}
     \item{\code{alpha}:}{a vector of length \code{N}. \code{cost[j]} is the cost
associated to partition \code{c[[j]]}}
      \item{\code{U_SS_list}:}{a list of length \code{N} containing the lists of
      sufficient statistics for all the mixture components at each MCMC iteration}
     \item{\code{weights_list}:}{a list of length \code{N} containing the weights of each
     mixture component for each MCMC iterations}
     \item{\code{logposterior_list}:}{a list of length \code{N} containing the logposterior values
      at each MCMC iterations}
     \item{\code{data}:}{the data matrix \code{d x n} with \code{d} dimensions in rows
and \code{n} observations in columns}
     \item{\code{nb_mcmcit}:}{the number of MCMC itertations}
     \item{\code{clust_distrib}:}{the parametric distribution of the mixture component - \code{"skewt"}}
     \item{\code{hyperG0}:}{the prior on the cluster location}
 }
}
\description{
Slice Sampling of Dirichlet Process Mixture of skew  Students's t-distibutions
}
\examples{
rm(list=ls())

#Number of data
n <- 2000
set.seed(123)
#set.seed(4321)


d <- 2
ncl <- 4

# Sample data

sdev <- array(dim=c(d,d,ncl))

xi <- matrix(nrow=d, ncol=ncl, c(-1.5, 1, 1.5, 1, 1.5, -2, -2, -2))
psi <- matrix(nrow=d, ncol=4, c(0.4, -0.6, 0.8, 0, 0.3, -0.7, -0.3, -0.8))
p <- c(0.2, 0.1, 0.4, 0.3) # frequence des clusters
sdev[, ,1] <- matrix(nrow=d, ncol=d, c(0.3, 0, 0, 0.3))
sdev[, ,2] <- matrix(nrow=d, ncol=d, c(0.1, 0, 0, 0.3))
sdev[, ,3] <- matrix(nrow=d, ncol=d, c(0.3, 0.15, 0.15, 0.3))
sdev[, ,4] <- .3*diag(2)


c <- rep(0,n)
z <- matrix(0, nrow=d, ncol=n)
for(k in 1:n){
 c[k] = which(rmultinom(n=1, size=1, prob=p)!=0)
 z[,k] <- (xi[, c[k]]
          + psi[, c[k]]*abs(rnorm(1))
          + sdev[, , c[k]]\%*\%matrix(rnorm(d, mean = 0, sd = 1), nrow=d, ncol=1))
 #cat(k, "/", n, " observations simulated\\n", sep="")
}

# Set parameters of G0
hyperG0 <- list()
hyperG0[["b_xi"]] <- rep(0,d)
hyperG0[["b_psi"]] <- rep(0,d)
hyperG0[["kappa"]] <- 0.001
hyperG0[["D_xi"]] <- 100
hyperG0[["D_psi"]] <- 100
hyperG0[["nu"]] <- d + 1
hyperG0[["lambda"]] <- diag(d)

 # hyperprior on the Scale parameter of DPM
 a <- 0.0001
 b <- 0.0001

 # do some plots
 doPlot <- TRUE
 nbclust_init <- 30



 ## Data
 ########
library(ggplot2)
 p <- (ggplot(data.frame("X"=z[1,], "Y"=z[2,]), aes(x=X, y=Y))
       + geom_point()
       + ggtitle("Simple example in 2d data")
       +xlab("D1")
       +ylab("D2")
       +theme_bw())
 p

 c2plot <- factor(c)
 levels(c2plot) <- c("3", "2", "4", "1")
 pp <- (ggplot(data.frame("X"=z[1,], "Y"=z[2,], "Cluster"=as.character(c2plot)))
       + geom_point(aes(x=X, y=Y, colour=Cluster, fill=Cluster))
       + ggtitle("Slightly overlapping skew-normal simulation\\n")
       + xlab("D1")
       + ylab("D2")
       + theme_bw()
       + scale_colour_discrete(guide=guide_legend(override.aes = list(size = 6, shape=22))))
 pp


 ## alpha priors plots
 #####################
 prioralpha <- data.frame("alpha"=rgamma(n=5000, shape=a, scale=1/b),
                         "distribution" =factor(rep("prior",5000),
                         levels=c("prior", "posterior")))
 p <- (ggplot(prioralpha, aes(x=alpha))
       + geom_histogram(aes(y=..density..),
                        colour="black", fill="white")
       + geom_density(alpha=.2, fill="red")
       + ggtitle(paste("Prior distribution on alpha: Gamma(", a,
                 ",", b, ")\\n", sep=""))
      )
 p


\dontrun{
 # Gibbs sampler for Dirichlet Process Mixtures
 ##############################################
 MCMCsample_st <- DPMGibbsSkewT(z, hyperG0, a, b, N=2000,
                                doPlot, nbclust_init, plotevery=100, gg.add=list(theme_bw(),
                                 guides(shape=guide_legend(override.aes = list(fill="grey45")))),
                                diagVar=FALSE)
 s <- summary(MCMCsample_st, burnin = 350)
 print(s)
 plot(s)
 plot_ConvDPM(MCMCsample_st, from=2)
 cluster_est_binder(MCMCsample_st$mcmc_partitions[1500:2000])
}



}
\author{
Boris Hejblum
}
\references{
Hejblum BP, Alkhassim C, Gottardo R, Caron F, Thiebaut R, Sequential Dirichlet
Process Mixtures of Multivariate Skew t-distributions for Model-based Clustering
of Flow Cytometry Data, in preparation.
}

