\name{nps.test}
\alias{nps.test}
\alias{print.nps.test}
\title{Significance tests and confidence intervals for Net Promoter Scores}
\usage{
nps.test(x, y = NULL, test = "wald", conf = 0.95, breaks = list(0:6,
  7:8, 9:10))

\method{print}{nps.test}(x, ...)
}
\arguments{
  \item{x}{A vector of \emph{Recommend} scores}

  \item{y}{A vector of \emph{Recommend} scores, to compare
  to \code{x}. If not specified, a one sample test on
  \code{x} is performed. Defaults to \code{NULL}}

  \item{test}{The type of test to perform. Currently only
  the Wald/Z-test ('\code{wald}') is supported}

  \item{conf}{the confidence level of the test and
  intervals. Defaults to 0.95}

  \item{\dots}{Not used.}

  \item{breaks}{A \code{list} of length three, giving the
  integer Likert scale points for \emph{Detractors},
  \emph{Passives}, and \emph{Promoters}, respectively. The
  default is \code{list(0:6, 7:8, 9:10)}}
}
\value{
A \code{\link{list}} of class \code{nps.test} containing:
\item{nps.x, nps.y}{The Net Promoter score(s)}
\item{delta}{Where both \code{x} and \code{y} have been
specified, the absolute difference between the two scores}
\item{int}{The confidence interval generated. For a one
sample test, this will be a confidence interval around
\code{nps.x}. For a two sample test, this will be a
confidence interval around the difference between
\code{nps.x} and \code{nps.y}} \item{conf}{The confidence
level used when performing the test, as specificed by
\code{conf} in the function parameters} \item{p.value}{The
p value of the significance test}
\item{sig}{\code{\link{logical}}. Whether or not the
\code{p.value} of the test exceeded 1-\code{conf}}
\item{se.hat}{The estimated standard error of \code{delta}
for a two sample test, otherwise of \code{x}}
\item{type}{\code{\link{character}} string indicating
whether a one or two sample test was performed} \item{n.x,
n.y}{Counts for \code{x} and \code{y}}

\code{NULL}
}
\description{
This function performs one and two sample tests for the Net
Promoter score(s) of \emph{Recommend} data distributions.
Currently, only a Wald type test is supported.
}
\author{
Brendan Rocks \email{rocks.brendan@gmail.com}
}
\seealso{
\code{\link{nps.var}}, \code{\link{nps.se}},
\code{\link{nps}}
}

