% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareZZ.R
\name{prepareZZ}
\alias{prepareZZ}
\title{Prepare a Dataset For All Possible Formats}
\usage{
prepareZZ(Z, xdmv = "m", ydmv = "v", zdm = "d", scale = FALSE)
}
\arguments{
\item{Z}{a matrix or a data.frame representing a dataset.}

\item{xdmv}{character, either "d", "m" or "v". The prefered output format for x: 
data.frame, matrix, vector (numeric).}

\item{ydmv}{character, either "d", "m" or "v". The prefered output format for y: 
data.frame, matrix, vector (numeric).}

\item{zdm}{character, either "d" or "m". The prefered output format for Zxy: 
data.frame or matrix.}

\item{scale}{logical. Scale x, y and Zxy with their respective means and standard
deviations.}
}
\value{
The output is a list, usually named \code{ZZ}, with the following items:
\itemize{
\item{Zxy: the original or scaled Z in the desired format (data.frame, matrix).}
\item{x: the original or scaled x in the desired format (data.frame, matrix, vector).}
\item{y: the original or scaled y in the desired format (data.frame, matrix, vector).}
\item{xory: the original x or y (as vector).}
\item{y0: the original y (as vector).}
\item{xm0: the mean(s) of the original x.}
\item{ym0: the mean of the original y.}
\item{xsd0: the standard deviation(s) of the original x.}
\item{ysd0: the standard deviation of the original y.}
\item{uni: the univariate (TRUE) or multivariate (FALSE) status of x (Z).}
\item{fmla: the formula \code{y ~ x} or \code{y ~ x1 + x2 + .. + xn} where n is the 
      number of inputs variables.}
}
The use of \code{attach()} and \code{detach()} gives direct access to the modified 
values of ZZ. See the examples.
}
\description{
This function modifies a dataset to the format required by a training function: 
data.frame, matrix or vector (numeric), pre-normalization.
}
\examples{
library("brnn")
library("validann")

maxit <- 200  # increase this number to get more accurate results with validann:ann
TF    <- TRUE # display the plots

### UNIVARIATE DATASET
Z     <- uGauss2
neur  <- 4

## brnn
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = FALSE) ; ht(ZZ) 
attach(ZZ)
y_pred <- ym0 + ysd0*predict(brnn(x, y, neur))
plotNN(xory, y0, uni, TF)
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 2)
ym0 ; ysd0
detach(ZZ) ; rm(y_pred)

\donttest{
## validann
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = TRUE) ; ht(ZZ)
attach(ZZ)
y_pred <- ym0 + ysd0*predict(validann::ann(x, y, neur, maxit = maxit))
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 3)
ym0 ; ysd0
detach(ZZ) ; rm(y_pred)


### UNIVARIATE DATASET + LOOP
nruns  <- 10

## brnn
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = FALSE) ; ht(ZZ) 
attach(ZZ)
Zreg <- list() ; Zreg
for (i in 1:nruns) Zreg[[i]] <- brnn::brnn(x, y, neur) 
m      <- matrix(sapply(Zreg, function(x) x$Ed) , ncol=1) ; m
best   <- which(min(m) == m)[1] ; best
y_pred <- ym0 + ysd0*predict(Zreg[[best]])
plotNN(xory, y0, uni, TF)
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 2)
detach(ZZ) ; rm(y_pred)

## validann
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = TRUE) ; ht(ZZ)
attach(ZZ)
Zreg <- list()
for (i in 1:nruns) Zreg[[i]] <- validann::ann(x, y, size = neur, maxit = maxit) 
m      <- matrix(sapply(Zreg, function(x) x$value), ncol=1) ; m
best   <- which(min(m) == m)[1] ; best
y_pred <- ym0 + ysd0*predict(Zreg[[best]])
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 4)
detach(ZZ) ; rm(y_pred)


### MULTIVARIATE DATASET
Z    <- mDette
neur <- 5

## brnn
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = FALSE) ; ht(ZZ)
attach(ZZ)
y_pred <- ym0 + ysd0*predict(brnn::brnn(x, y, neur))
plotNN(xory, y0, uni, TF)
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 2)
ym0 ; ysd0
detach(ZZ) ; rm(y_pred)

## validann
ZZ <- prepareZZ(Z, xdmv = "m", ydmv= "v", scale = TRUE) ; ht(ZZ)
attach(ZZ)
y_pred <- ym0 + ysd0*predict(validann::ann(x, y, neur, maxit = maxit))
lipoNN(xory, y_pred, uni, TF, lwd = 4, col = 3)
ym0 ; ysd0
detach(ZZ) ; rm(y_pred)


### INSIDE A FUNCTION
plotds <- function(Z, xdmv = "m", ydmv = "v", scale = FALSE, neurons = 3, col = 2) {
    ZZ <- prepareZZ(Z, xdmv = xdmv, ydmv= ydmv, scale = scale) 
    attach(ZZ) ; on.exit(detach(ZZ))
    y_pred <- ym0 + ysd0*predict(brnn::brnn(x, y, neurons))
    plotNN(xory, y0, uni, TF)
    lipoNN(xory, y_pred, uni, TF, lwd = 4, col = col)
    print(ht(x))
    print(ht(y))
}
plotds(uNeuroOne, scale = FALSE, neurons = 2, col = 2)
plotds(uNeuroOne, scale = TRUE,  neurons = 3, col = 3)

plotds(mFriedman, scale = TRUE,  neurons = 5, col = 4)
}


}
