% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add2csv.R
\name{add2csv}
\alias{add2csv}
\title{Create or Append a data.frame to a csv File}
\usage{
add2csv(x, file = "results.csv", dir = ".")
}
\arguments{
\item{x}{a data.frame or a matrix.}

\item{file}{character. The filename.}

\item{dir}{character. The directory in which the file is written. 
Default value \code{"."} is the current directory.}
}
\value{
Nothing in the console. A csv file on the disk.
}
\description{
Create or append a data.frame to a csv file. Column names are added at creation and 
ignored at the append steps.
}
\examples{
results_csv <- tempfile("results", fileext = ".csv")
x <- data.frame(a = 1:3, b = 4:6) 
add2csv(x, file = results_csv) 
add2csv(x*10, file = results_csv) 
add2csv(x*100, file = results_csv) 
read.csv(file = results_csv) 

}
