% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_dx.R
\name{dy.dx}
\alias{dy.dx}
\title{Partial Derivative dy/dx}
\usage{
dy.dx(x, y, eval.point = median(x), deriv.method = "FD")
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{eval.point}{numeric or ("overall"); \code{x} point to be evaluated.  Defaults to \code{(eval.point = median(x))}.  Set to \code{(eval.point = "overall")} to find an overall partial derivative estimate (1st derivative only).}

\item{deriv.method}{method of derivative estimation, options: ("NNS", "FD"); Determines the partial derivative from the coefficient of the \link{NNS.reg} output when \code{(deriv.method = "NNS")} or generates a partial derivative using the finite difference method \code{(deriv.method = "FD")} (Defualt).}
}
\value{
Returns a list of both 1st and 2nd derivative:
\itemize{
\item{\code{dy.dx(...)$First}} the 1st derivative.
\item{\code{dy.dx(...)$Second}} the 2nd derivative.
}
}
\description{
Returns the numerical partial derivate of \code{y} wrt \code{x} for a point of interest.
}
\note{
If a vector of derivatives is required, ensure \code{(deriv.method = "FD")}.
}
\examples{
\dontrun{
x <- seq(0, 2 * pi, pi / 100) ; y <- sin(x)
dy.dx(x, y, eval.point = 1.75)

# Vector of derivatives
dy.dx(x, y, eval.point = c(1.75, 2.5), deriv.method = "FD")}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"
\url{https://link.springer.com/article/10.1007/s10614-017-9713-5}
}
\author{
Fred Viole, OVVO Financial Systems
}
