% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{NNS.ANOVA}
\alias{NNS.ANOVA}
\title{NNS ANOVA}
\usage{
NNS.ANOVA(
  control,
  treatment,
  confidence.interval = 0.95,
  tails = "Both",
  pairwise = FALSE,
  plot = TRUE,
  binary = TRUE
)
}
\arguments{
\item{control}{a numeric vector, matrix or data frame.}

\item{treatment}{\code{NULL} (default) a numeric vector, matrix or data frame.}

\item{confidence.interval}{numeric [0, 1]; The confidence interval surrounding the control mean when \code{(binary = TRUE)}.  Defaults to \code{(confidence.interval = 0.95)}.}

\item{tails}{options: ("Left", "Right", "Both").  \code{tails = "Both"}(Default) Selects the tail of the distribution to determine effect size.}

\item{pairwise}{logical; \code{FALSE} (defualt) Returns pairwise certainty tests when set to \code{pairwise = TRUE}.}

\item{plot}{logical; \code{TRUE} (default) Returns the boxplot of all variables along with grand mean identification.  When \code{(binary = TRUE)}, returns the boxplot of both variables along with grand mean identification and confidence interval thereof.}

\item{binary}{logical; \code{TRUE} (default) Selects binary analysis between a control and treatment variable.}
}
\value{
For \code{(binary = FALSE)} returns the degree certainty the difference in sample means is zero [0, 1].

For \code{(binary = TRUE)} returns:
\itemize{
\item{\code{"Control Mean"}}
\item{\code{"Treatment Mean"}}
\item{\code{"Grand Mean"}}
\item{\code{"Control CDF"}}
\item{\code{"Treatment CDF"}}
\item{\code{"Certainty"}} the certainty of the same population statistic
\item{\code{"Lower Bound Effect"} and \code{"Upper Bound Effect"}} the effect size of the treatment for the specified confidence interval
}
}
\description{
Analysis of variance (ANOVA) based on lower partial moment CDFs for multiple variables.  Returns a degree of certainty the difference in sample means is zero, not a p-value.
}
\examples{
### Binary analysis and effect size
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.ANOVA(control = x, treatment = y)

### Two variable analysis with no control variable
A <- cbind(x, y)
NNS.ANOVA(A)

### Multiple variable analysis with no control variable
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
A <- cbind(x, y, z)
NNS.ANOVA(A)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
