% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNS_VAR.R
\name{NNS.VAR}
\alias{NNS.VAR}
\title{NNS VAR}
\usage{
NNS.VAR(variables, h, tau = 1, dim.red.method = "cor",
  obj.fn = expression(sum((predicted - actual)^2)), objective = "min",
  status = TRUE, ncores = NULL)
}
\arguments{
\item{variables}{a numeric matrix or data.frame of contemporaneous time-series to forecast.}

\item{h}{integer; 1 (default) Number of periods to forecast.}

\item{tau}{positive integer [ > 0]; 1 (default) Number of lagged observations to consider for the time-series data.  Vector for single lag for each respective variable or list for multiple lags per each variable.}

\item{dim.red.method}{options: ("cor", "NNS.dep", "NNS.caus", "all") method for reducing regressors via \link{NNS.stack}.  \code{(dim.red.method = "cor")} (default) uses standard linear correlation for dimension reduction in the lagged variable matrix.  \code{(dim.red.method = "NNS.dep")} uses \link{NNS.dep} for nonlinear dependence weights, while \code{(dim.red.method = "NNS.caus")} uses \link{NNS.caus} for causal weights.  \code{(dim.red.method = "all")} averages all methods for further feature engineering.}

\item{obj.fn}{expression;
\code{expression(sum((predicted - actual)^2))} (default) Sum of squared errors is the default objective function.  Any \code{expression()} using the specific terms \code{predicted} and \code{actual} can be used.}

\item{objective}{options: ("min", "max") \code{"min"} (default) Select whether to minimize or maximize the objective function \code{obj.fn}.}

\item{status}{logical; \code{TRUE} (default) Prints status update message in console.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized subroutine \link{NNS.ARMA.optim}. If NULL (default), the number of cores to be used is equal to the number of cores of the machine - 1.}
}
\value{
Returns the following matrices of forecasted variables:
\itemize{
 \item{\code{"relevant_variables"}} Returns the relevant variables from the dimension reduction step.

 \item{\code{"univariate"}} Returns the univariate \link{NNS.ARMA} forecasts.

 \item{\code{"multivariate"}} Returns the multi-variate \link{NNS.reg} forecasts.

 \item{\code{"ensemble"}} Returns the ensemble of both \code{"univariate"} and \code{"multivariate"} forecasts.
 }
}
\description{
Nonparametric vector autoregressive model incorporating \link{NNS.ARMA} estimates of variables into \link{NNS.reg} for a multi-variate time-series forecast.
}
\note{
\code{dim.red.method = "cor"} is significantly faster than the other methods, but comes at the expense of ignoring possible nonlinear relationships between lagged variables.
}
\examples{

 \dontrun{
 set.seed(123)
 x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
 A <- cbind(x = x, y = y, z = z)

 ### Using lags 1:4 for each variable
 NNS.VAR(A, h = 12, tau = 4, status = TRUE)

 ### Using lag 1 for variable 1, lag 3 for variable 2 and lag 3 for variable 3
 NNS.VAR(A, h = 12, tau = c(1,3,3), status = TRUE)

 ### Using lags c(1,2,3) for variables 1 and 3, while using lags c(4,5,6) for variable 2
 NNS.VAR(A, h = 12, tau = list(c(1,2,3), c(4,5,6), c(1,2,3)), status = TRUE)
 }

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995}

Viole, F. (2019) "Multi-variate Time-Series Forecasting: Nonparametric Vector Autoregression Using NNS"
\url{https://ssrn.com/abstract=3489550}

Viole, F. (2019) "Forecasting Using NNS"
\url{https://ssrn.com/abstract=3382300}

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"
\url{https://link.springer.com/article/10.1007/s10614-017-9713-5}

Vinod, H. and Viole, F. (2018) "Clustering and Curve Fitting by Line Segments"
\url{https://www.preprints.org/manuscript/201801.0090/v1}
}
\author{
Fred Viole, OVVO Financial Systems
}
