% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic-ctl-manipulation.R
\name{insert_dollar}
\alias{insert_dollar}
\title{Insert a new subroutine into control file_contents}
\usage{
insert_dollar(m, dollar, text, after_dollar)
}
\arguments{
\item{m}{An nm object.}

\item{dollar}{Character. Name of subroutine to insert.}

\item{text}{Character vector. Text to fill.}

\item{after_dollar}{Character name of preceding subroutine. The new
subroutine will be inserted immediately after it.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Mostly a back end function used by other functions.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m1 <- m1 \%>\% insert_dollar("MODEL", "
$MODEL
COMP = (CENTRAL)
", after_dollar = "SUB")

m1 \%>\% dollar("MODEL")

}
