% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nm_diff.R
\name{nm_diff}
\alias{nm_diff}
\title{Compute diff between two NONMEM runs}
\usage{
nm_diff(m, ref_m, format = "raw")
}
\arguments{
\item{m}{An nm object.}

\item{ref_m}{An optional nm object (base/reference object).  If not
specified, it will compute the diff the initial control file contents
associated with the object at the time of object create.  This information
is stored in the \code{ctl_orig} field.}

\item{format}{Character (default = \code{"raw"}) argument passed to
\code{\link[diffobj:diffChr]{diffobj::diffChr()}}}
}
\value{
Invisibly returns a \code{character} vector of the diff.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The easiest way to use this function is via the "view diff" RStudio 'Addin'.

NMproject's control file manipulation functions (e.g. \code{\link[=subroutine]{subroutine()}})
may not work for all control files. It is the responsibility of
the user to check automatic manipulations are done properly.
Displaying diffs provides a means of manually checking what was done.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

m2 <- m1 \%>\% child(run_id = "m2") \%>\%
  subroutine(advan = 2, trans = 2)

nm_diff(m2, m1)

}
