% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMreadParsText.R
\name{NMreadParsText}
\alias{NMreadParsText}
\title{Read comments to parameter definitions in Nonmem control streams}
\usage{
NMreadParsText(
  file,
  fields,
  fields.omega = fields,
  fields.sigma = fields.omega,
  use.theta.nums = FALSE,
  spaces.split = FALSE
)
}
\arguments{
\item{file}{Path to the control stream to read.}

\item{fields}{Defines naming and splitting of contents of lines in
parameter sections. Default is
\code{"\%init;\%symbol;\%num;\%label;\%unit"}.}

\item{fields.omega}{Like `fields`, applied to `$OMEGA`
section. Default is to reuse `fields`.}

\item{fields.sigma}{Like `fields`, applied to `$SIGMA`
section. Default is to reuse `fields.omega`.}

\item{use.theta.nums}{If the num field should be used to number
thetas. I do not see where this is advantageous to do.}

\item{spaces.split}{Is a blank in `fields` to be treated as a
field seperator? Default is not to (i.e. neglect spaces in
`fields`).}
}
\description{
When interpreting parameter estimates, it is often needed to
recover information about the meaning of the different parameters
from control stream. `NMreadParsText` provides a flexible way to
organize the comments in the parameter sections into a
`data.frame`. This can subsequently easily be merged with parameter
values as obtained with `NMreadExt`.
}
\details{
Off-diagonal omega and sigma elements will only be
    correctly treated if their num field specifies say 1-2 to
    specify it is covariance between 1 and 2.
}
