% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_survey.R
\name{el_survey}
\alias{el_survey}
\alias{el.survey.design}
\title{Empirical likelihood for survey designs (NMAR)}
\usage{
\method{el}{survey.design}(
  data,
  formula,
  auxiliary_means = NULL,
  standardize = TRUE,
  strata_augmentation = TRUE,
  trim_cap = Inf,
  control = list(),
  on_failure = c("return", "error"),
  variance_method = c("bootstrap", "none"),
  bootstrap_reps = 500,
  n_total = NULL,
  start = NULL,
  trace_level = 0,
  family = logit_family(),
  ...
)
}
\arguments{
\item{data}{A \code{survey.design} created with \code{survey::svydesign()}.}

\item{formula}{Two-sided formula with an NA-valued outcome on the LHS;
auxiliaries on the first RHS and, optionally, missingness predictors on
the second RHS partition.}

\item{auxiliary_means}{Named numeric vector of population means for auxiliary
design columns. Names must match the materialized \code{model.matrix} columns on
the first RHS (after formula expansion), including factor indicators and
transformed terms. The intercept is always excluded.}

\item{standardize}{Logical; standardize predictors.}

\item{strata_augmentation}{Logical; when \code{TRUE} (default), augment the
auxiliary design with stratum indicators and stratum shares when a strata
structure is present in the survey design.}

\item{trim_cap}{Numeric; cap for EL weights (\code{Inf} = no trimming).}

\item{control}{List; solver control for \code{nleqslv::nleqslv(control = ...)}.}

\item{on_failure}{Character; \code{"return"} or \code{"error"} on solver failure.}

\item{variance_method}{Character; \code{"bootstrap"} or \code{"none"}.}

\item{bootstrap_reps}{Integer; reps when \code{variance_method = "bootstrap"}.}

\item{n_total}{Optional analysis-scale population size \code{N_pop}; required for respondents-only designs.}

\item{start}{Optional list of starting values passed to solver helpers.}

\item{trace_level}{Integer 0-3 controlling estimator logging detail.}

\item{family}{Missingness (response) model family specification (defaults to logit).}

\item{...}{Passed to solver.}
}
\value{
\code{c("nmar_result_el","nmar_result")}.
}
\description{
Internal method dispatched by \code{el()} when \code{data} is a
  \code{survey.design}.
}
\details{
Implements the empirical likelihood estimator with design weights.
  If \code{n_total} is supplied, it is treated as the analysis-scale population
  size \code{N_pop} used in the design-weighted QLS system. If \code{n_total}
  is not supplied, \code{sum(weights(design))} is used as \code{N_pop}. Design
  weights are not rescaled internally; the EL equations use respondent weights
  and \code{N_pop} via \eqn{T_0 = N_{\mathrm{pop}} - \sum d_i} in the linkage equation.
  When respondents-only designs are used (no NA in the outcome), \code{n_total}
  must be provided; if auxiliaries are requested you must also provide
  population auxiliary means via \code{auxiliary_means}. Result weights are the
  unnormalized EL masses \eqn{d_i / D_i(\theta)} on this analysis scale;
  \code{weights(result, scale = "population")} sums to \code{N_pop}.
}
\keyword{internal}
