% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_mosaictess.R
\name{nlm_mosaictess}
\alias{nlm_mosaictess}
\alias{nlm_polylands}
\title{nlm_mosaictess}
\usage{
nlm_mosaictess(ncol, nrow, resolution = 1, germs, rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{germs}{[\code{numerical(1)}]\cr
Intensity parameter (non-negative integer).}

\item{rescale}{[\code{logical(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulate a neutral landscape model using the tesselation approach introduced in Gaucherel (2008).
}
\details{
\code{nlm_mosaictess} offers the first option of simulating a neutral landscape model
described in Gaucherel (2008). It generates a random point pattern (germs)
with an independent distribution and uses the Voronoi tessellation to simulate mosaic landscapes.
}
\examples{
# simulate polygonal landscapes
mosaictess <- nlm_mosaictess(ncol = 30, nrow = 60, germs = 200)

\dontrun{
# visualize the NLM
rasterVis::levelplot(mosaictess, margin = FALSE, par.settings = rasterVis::viridisTheme())
}

}
\references{
Gaucherel, C. (2008) Neutral models for polygonal landscapes with linear
networks. \emph{Ecological Modelling}, 219, 39 - 48.
}
