% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_neigh.R
\name{nlm_neigh}
\alias{nlm_neigh}
\title{nlm_neigh}
\usage{
nlm_neigh(ncol, nrow, resolution = 1, p_neigh, p_empty, categories = 3,
  neighbourhood = 4, proportions = NA, rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns forming the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows forming the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{p_neigh}{[\code{numerical(1)}]\cr
Probability of a cell will turning into a value if there is any neighbor with the same or a
 higher value.}

\item{p_empty}{[\code{numerical(1)}]\cr
Probability a cell receives a value if all neighbors have no value (i.e.
zero).}

\item{categories}{[\code{numerical(1)}]\cr
Number of categories used.}

\item{neighbourhood}{[\code{numerical(1)}]\cr
The neighbourhood used to determined adjacent cells: `8 ("Moore")` takes the eight
surrounding cells, while `4 ("Von-Neumann")` takes the four adjacent cells
(i.e. left, right, upper and lower cells).}

\item{proportions}{[\code{vector(1)}]\cr
The algorithm uses uniform proportions for each category by default. A vector
with as many proportions as categories and that sums up to 1 can be used for
other distributions.}

\item{rescale}{[\code{logical(1)}]\cr If \code{TRUE} (default), the values
are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Create a neutral landscape model with categories and clustering
 based on neighborhood characteristics.
}
\details{
The algorithm draws a random cell and turns it into a given category based on
 the probabilities \code{p_neigh} and \code{p_empty}, respectively. The decision is
 based on the probability \code{p_neigh}, if there is any cell in the Moore- (8 cells) or
 Von-Neumann-neighborhood (4 cells), otherwise it is based on \code{p_empty}. To create
 clustered neutral landscape models, \code{p_empty} should be (significantly) smaller than
 \code{p_neigh}. By default, the Von-Neumann-neighborhood is used to check adjacent
 cells. The algorithm starts with the highest categorial value. If the
 proportion of cells with this value is reached, the categorial value is
 reduced by 1. By default, a uniform distribution of the categories is
 applied.
}
\examples{
# simulate neighborhood model
neigh_raster <- nlm_neigh(ncol = 50, nrow = 50, p_neigh = 0.1, p_empty = 0.3,
                    categories = 5, neighbourhood = 4)

\dontrun{
# visualize the NLM
rasterVis::levelplot(neigh_raster, margin = FALSE, par.settings = rasterVis::viridisTheme())
}

}
\references{
Scherer, Cédric, et al. "Merging trait-based and individual-based modelling:
An animal functional type approach to explore the responses of birds to
climatic and land use changes in semi-arid African savannas."
\emph{Ecological Modelling} 326 (2016): 75-89.
}
