% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ngchmCreateServerProtocol}
\alias{ngchmCreateServerProtocol}
\title{Create and register an NGCHM server protocol implementation.}
\usage{
ngchmCreateServerProtocol(
  protocolName,
  chmFormat,
  requiredParams,
  optionalParams,
  paramValidator,
  findCollection,
  createCollection,
  installMethod,
  uninstallMethod,
  makePrivate,
  makePublic,
  setCredentials
)
}
\arguments{
\item{protocolName}{A single character string specifying the name of the protocol.}

\item{chmFormat}{A single character string specifying the format of the heat map.
Defaults to "original".}

\item{requiredParams}{A character vector specifying the required parameters for the
protocol, if any.}

\item{optionalParams}{A character vector specifying the optional parameters for the
protocol, if any.}

\item{paramValidator}{A function(list) for validating the parameters specified
for a new server.}

\item{findCollection}{A function(server,collection,path) that finds a collection
on the server.}

\item{createCollection}{A function(server,collection,name) that creates a collection
on the server.}

\item{installMethod}{A function(server,chm) that installs a heat map on the server.}

\item{uninstallMethod}{A function(server,chmname) that uninstalls a heat map
from the server.}

\item{makePrivate}{A function(server,chmname) that makes a heat map private
on the server.}

\item{makePublic}{A function(server,chmname) that makes a heat map public on the
server.}

\item{setCredentials}{A function(server,credentialstring) that sets the credentials
for the server.}
}
\value{
An object of class 'ngchmServerProtocol' representing the new server protocol.
}
\description{
This function creates and registers a protocol implementation for manipulating
an NGCHM server.
}
