% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmAddUWOT}
\alias{chmAddUWOT}
\title{Add UWOT::UMAP coordinates to an NG-CHM.}
\usage{
chmAddUWOT(hm, axis, uwot, pointIds, basename = "UMAP")
}
\arguments{
\item{hm}{The NGCHM to add the coordinates to.}

\item{axis}{The NGCHM axis ("row" or "column") to add the coordinates to.}

\item{uwot}{UMAP coordinates (output of \href{https://CRAN.R-project.org/package=uwot}{uwot::umap()}) for the specified NGCHM axis.}

\item{pointIds}{The NGCHM names for the data points in uwot}

\item{basename}{The prefix to use for the coordinate names.}
}
\value{
The NGCHM with added coordinates.
}
\description{
Add UWOT::UMAP coordinates as hidden covariate bars to an axis of an NG-CHM.  One hidden
covariate bar is added for each UMAP coordinate.  Coordinates have names 'BASENAME.coordinate.N',
where BASENAME is specified by the parameter basename (default UMAP) and N ranges from 1 to the number of
added covariate bars.
}
\details{
pointIds is required because \href{https://CRAN.R-project.org/package=uwot}{uwot::umap()} does not preserve the rownames of the data matrix it was applied to.
Their values must match those on that axis of the NGCHM, but their order must match those in the data
matrix passed to \href{https://CRAN.R-project.org/package=uwot}{uwot::umap()}.
}
\examples{
# Examples using `chmNew()` require git to be installed.
\dontrun{
  # If the NGCHMDemoData package is installed, use it to demo usage
  if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
    data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
    umc <- uwot::umap(t(TCGA.GBM.EXPR[1:50, 1:50]))
    hm <- chmNew("gbm", TCGA.GBM.EXPR[1:50, 1:50])
    hm <- chmAddUWOT(hm, "column", umc, colnames(TCGA.GBM.EXPR[1:50, 1:50]))
  }
  # Small example not requiring NGCHMDemoData
  matrix <- matrix(rnorm(100),
    nrow = 10, ncol = 10,
    dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
  )
  umc <- uwot::umap(t(matrix), n_neighbors = 8)
  hm <- chmNew("Demo UMAP", matrix)
  hm <- chmAddUWOT(hm, "column", umc, colnames(matrix))
}

}
\seealso{
\code{\link[=chmAddPCA]{chmAddPCA()}}

\code{\link[=chmAddTSNE]{chmAddTSNE()}}

\code{\link[=chmAddUMAP]{chmAddUMAP()}}

\code{\link[=chmAddReducedDim]{chmAddReducedDim()}}
}
