% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmLayer<-}
\alias{chmLayer<-}
\title{Set (or append) a specified Data Layer in an NG-CHM.}
\arguments{
\item{x}{The NG-CHM object to set the data layer of}

\item{label}{The name or index of the data layer to set.  If a name, replace the layer with
that name.  Append a new layer if no layer with that name exists.  If an index,
replace the specified layer.  If zero (0), prepend the new layer.  If minus one (-1)
or N+1 (for an NG-CHM with N layers), appends a new layer.}

\item{colors}{A colormap for the new layer.  If missing, defaults to the color map of the
layer being replaced, or to the default new layer color map for a new layer.}

\item{summarizationMethod}{The summarization method for the new layer.  If
missing, defaults to the summarization method of the layer being
replaced, or to the default new layer summarization method for a new layer.}

\item{cuts_color}{The cuts color for the new layer.  If
missing, defaults to the cuts color of the layer being
replaced, or to the default cuts color for a new layer.}

\item{value}{Either a matrix or a data layer to set in the NG-CHM.  If value is a matrix,
the other data layer parameters (label, colors, summarizationMethod,
and cuts_color) are set from the parameters if specified, from the old
data layer (if any), or the defaults for a new data layer (see chmNewDataLayer).
If value is a data layer, any other data layer parameters specified will
override those in the replacement layer.}
}
\value{
An object of class ngchm.
}
\description{
This function sets a Data Layer in a Next Generation Clustered Heat Map.
}
\examples{
# If the NGCHMDemoData package is installed, use demo usage
if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
  data(TCGA.GBM.Demo, package = "NGCHMDemoData")
  matrix <- TCGA.GBM.ExpressionData[1:50, 1:50]
  hm <- chmNew("New Heat Map")
  chmLayer(hm, "Layer 1") <- matrix
  chmLayer(hm, 1, cuts_color = "#fefefe") <- chmNewDataLayer("New data layer", matrix + 1)
}
# Small example not requiring NGCHMDemoData
matrix <- matrix(rnorm(100),
  nrow = 10, ncol = 10,
  dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
)
hm <- chmNew("New Heat Map")
chmLayer(hm, "Layer 1") <- matrix
chmLayer(hm, 1, cuts_color = "#fefefe") <- chmNewDataLayer("New data layer", matrix + 1)

}
\seealso{
\linkS4class{ngchmLayer}

chmNewDataLayer
}
