% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmNewFunction}
\alias{chmNewFunction}
\title{Create a new Javascript function for adding to a NGCHM menu.}
\usage{
chmNewFunction(
  name,
  description,
  implementation,
  extraParams = NULL,
  requires = NULL,
  global = FALSE
)
}
\arguments{
\item{name}{The name of the Javascript function}

\item{description}{A short description of the Javascript function}

\item{implementation}{A string containing the javascript code required to define the function. When called the function
is passed a list of selected values (e.g. labels).  Additional parameters can be declared before the values
parameter and must be resolved through currying (binding) before the function is used in menus.}

\item{extraParams}{An optional list of extra parameters. (Default NULL.)}

\item{requires}{An optional vector of (custom) Javascript function names that this function requires.}

\item{global}{A logical: TRUE if should be defined globally, not within a customization section. (Default FALSE.)}
}
\value{
An object of class ngchmJS
}
\description{
This function creates a new Javascript function object for adding to
a Next Generation Clustered Heat Map menu.
}
\examples{
alertFn <- chmNewFunction("showAlert", "Display the parameter in an alert box",
  "function showAlert(label) { alert(label); }",
  global = TRUE
)
dbLookup <- chmNewFunction(
  "dbLookup", "Lookup the parameter in a database",
  "function showAlert(database, label) { alert(database[label]); }",
  c("database")
)

}
\seealso{
\linkS4class{ngchmJS}

\code{\link[=chmAddMenuItem]{chmAddMenuItem()}}

\code{\link[=chmBindFunction]{chmBindFunction()}}

\code{\link[=chmRegisterFunction]{chmRegisterFunction()}}
}
