\name{NCA-package}
\docType{package}
\title{Necessary Condition Analysis}
\description{The NCA package implements Necessary Condition Analysis (NCA) as developed by Dul (2016). For running the NCA package a data file (e.g., mydata.csv, which contains the input data) must be available. An example data file (presented in above paper) is included in the package. The user must load the data and call the nca function.}
\details{\tabular{ll}{
Package:  \tab NCA\cr
Type:     \tab Package\cr
Version:  \tab 3.0.1\cr
Date:     \tab 2018-08-21\cr
License:  \tab GPL (>= 3)\cr}
}
\author{
Author: Jan Dul \email{jdul@rsm.nl}\cr
Maintainer: Govert Buijs \email{buijs@rsm.nl}
}
\references{
Dul, J. 2016. Necessary Condition Analysis (NCA).
\dQuote{Logic and Methodology of 'Necessary but not Sufficient' causality.}
This paper is published in Organizational Research Methods 19(1), 10-52 (Sage publishers)\cr
\href{http://dx.doi.org/10.2139/ssrn.2588480}{http://dx.doi.org/10.2139/ssrn.2588480}
}
\seealso{
\code{\link{nca_analysis}}, \code{\link{nca_output}}
}
\keyword{package}

\examples{
# A more detailed guide can be found here : http://repub.eur.nl/pub/78323/
# or https://ssrn.com/abstract=2624981

# Load data from a CSV file with header and row names:
\donttest{\dontshow{try(}data <- read.csv('mydata.csv', row.names=1)\dontshow{, silent=TRUE)}}
# Or load the example dataset
data(nca.example)
data <- nca.example

# Run NCA with the dataset.
# Specify the independent (cause) and dependent (effect) variables
# More than 1 independent variables can be specified with a vector
model <- nca_analysis(data, c(1, 2), 3)

# A quick summary can be displayed by printing the model
model

# A full summary is shown by nca_output (see documentation for more options)
nca_output(model)

# The model is a list of 6 items :
# - plots (1 for each independent variable)
# - summaries (1 for each independent variable)
# - bottleneck tables (1 for each ceiling technique)
# - peers (1 dataframe for each independent variable)
# - tests (1 list for each independent variabl)
# - test.time (total time to run all tests)
names(model)

# The first item contains the graphical outputs for each independent variable
# This is not really useful to humans
model$plots[[1]]

# The seconds item contains a list with the summaries for the independent variables
model$summaries[[1]]

# The third item contains a list with the bottleneck tables, one for each ceiling technique
model$bottlenecks$cr_fdh

# The fourth item shows the peers, for each independent variable
model$peers$Individualism

# For the fifth and sixth item, the test.rep needs to be bigger than 0
# Optionally the p_confidence (default 0.95) and the p_threshold (default 0) can be set
model <- nca_analysis(data, c(1, 2), 3, test.rep=100)

# The fifth item shows the tests for each independent variable
# This is not really useful to humans
model$tests$Individualism

# The last item shows the total time needed to perform the tests
model$test.time
}