% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_methods.R
\docType{methods}
\name{selectedFeatures}
\alias{selectedFeatures}
\alias{selectedFeatures,nblda-method}
\alias{selectedFeatures,nblda_trained-method}
\title{Accessors for the 'selectedFeatures' slot.}
\usage{
\S4method{selectedFeatures}{nblda}(object)

\S4method{selectedFeatures}{nblda_trained}(object)
}
\arguments{
\item{object}{an \code{nblda} or \code{nblda_trained} object.}
}
\value{
a list of selected features info including the followings:
\item{idx}{column indices of selected features/variables}
\item{names}{column names of selected features/variables if input data have pre-defined column names.}
}
\description{
This slot, if not NULL, stores the selected features/variables for sparse model.
}
\note{
If \code{return.selected.features} = FALSE within \code{\link{nbldaControl}} or all features/variables
are selected and used in discrimination function, \code{idx} and \code{names} are returned NULL.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 50, K = 2, param = 1, sdsignal = 0.5, DE = 0.6,
                            allZero.rm = FALSE, tag.samples = TRUE)
x <- t(counts$x + 1)
y <- counts$y
xte <- t(counts$xte + 1)
ctrl <- nbldaControl(folds = 2, repeats = 2, return.selected.features = TRUE,
                     transform = TRUE, phi.epsilon = 0.10)

fit <- trainNBLDA(x = x, y = y, type = "mle", tuneLength = 10,
                  metric = "accuracy", train.control = ctrl)

selectedFeatures(fit)

}
\seealso{
\code{\link{trainNBLDA}}, \code{\linkS4class{nblda}}, \code{\linkS4class{nblda_trained}}
}
