% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCountData.R
\name{generateCountData}
\alias{generateCountData}
\title{Generate Count Data}
\usage{
generateCountData(n, p, K, param, sdsignal = 1, DE = 0.3,
  allZero.rm = TRUE, tag.samples = FALSE)
}
\arguments{
\item{n}{number of samples.}

\item{p}{number of variables/features.}

\item{K}{number of classes.}

\item{param}{overdispersion parameter. This parameter is matched with the arguement \code{size} in \code{\link[stats]{rnbinom}} function.
Hence, Negative Binomial distribution aproximates to Poisson distribution as \code{param} increases.}

\item{sdsignal}{a nonzero numeric value. As \code{sdsignal} increases, the observed counts greatly differs among K classes.}

\item{DE}{a numeric value within the interval [0, 1]. This is the proportion of total number of variables that is significantly
different among K classes. The remaining part is assumed to be having no contribution to discrimination function.}

\item{allZero.rm}{a logical. If TRUE, columns having all zero cells are dropped.}

\item{tag.samples}{a logical. If TRUE, rownames are automatically generated. A tag for each sample such as "S1", "S2", etc.}
}
\value{
\item{\code{x, xte}}{count data matrix for training and test set.}
\item{\code{y, yte}}{class labels for training and test set.}
\item{\code{truesf, truesfte}}{true size factors for training and test set. See Witten (2011) for more information on estimating size factors.}
}
\description{
This function can be used to generate counts, e.g RNA-Sequencing data, for both classification and clustering purposes.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5, DE = 0.8,
                            allZero.rm = FALSE, tag.samples = TRUE)
head(counts$x)

}
\author{
Dincer Goksuluk
}
