\name{calibrate.sigmoid.curve}
\alias{calibrate.sigmoid.curve}
\title{
calibrate.sigmoid.curve is a curve fitting utility function.
}
\description{
Calibrate.sigmoid.curve is a utility function used to fit the parameters for the sigmoidparameters option within NAPPA controlling the degree of shrinkage applied to the housekeeping normalisation.  This may be useful if applying NAPPA to a new sample type.  It is recommended that this is only performed once a sizeable data corpis has been collected over multiple seperate experiments.
}
\usage{
calibrate.sigmoid.curve(
	data,
	plotit=T,
	plotspline=F,
	plotbyds=F)
}
\arguments{
  \item{data}{
This should be the output RCC files from the Nanostring nCounter software, saved as a tab delimited text file. If there are multiple cartridges from the same experiment - simply merge together into a single file to run. In the first column, housekeeping genes should be indicated by changing the standard 'Endogenous,' call generated by nCounter to 'Housekeeping.'
}
  \item{plotit}{
Produce a scatterplot of gene slope against average gene expression, showing the fitted sigmoid curve.
}
  \item{plotspline}{
Add a spline fit to check the quality of fit of the sigmoid curve.
}
  \item{plotbyds}{
Add individual curves for each individual dataset in the list to check for heterogeneity between datasets.
}
}
\details{
For each endogenous gene within each dataset a linear regression is performed of the expression level after positive control normalisation but before the housekeeping normalisation step in NAPPA against the housekeeping normalisation factor.  The estimated slopes with their standard errors are recorded along with the average expression level of the gene. A sigmoid curve is fitted over all observations, modelling slope between zero and one as a function of average gene expression, with observations weighted by the inverse of the standard error of regression.  
}
\value{
A vector of length two giving the fitted scale and slope parameters for the fitted sigmoid curve which can be passed to the sigmoidparameters argument in NAPPA.
}

\author{
Chris Harbron
}

\keyword{ Nanostring }
