\name{NAPPA}
\alias{NAPPA}
\title{NAPPA: A novel statistical method for the processing and normalisation of mRNA data output from the Nanostring nCounter software}
\description{
Enables the processing and normalisation of the mRNA data output from the Nanostring nCounter software.  Performs an adjustment based on the observed field of view for each lane.  Performs a background correction using the truncated Poisson distribution adjustment.  Performs a positive control normalisation using the E2 value.  Performs a housekeeper normalisation by estimating the slope multiplier from sigmoidal curve fit.
}
\usage{
NAPPA(
	data, 
	tissueType = tissueType, 
	sampleNumber = sampleNumber
	)
}
\arguments{
  \item{data}{This should be the output RCC files from the Nanostring nCounter software, saved as a tab delimited text file.  If there are multiple cartridges from the same experiment - simply merge together into a single file to run.  In the first column, housekeeping genes should be indicated by changing the standard 'Endogenous,' call generated by nCounter to 'Housekeeping.'  The top 2 empty rows of the RCC file MUST be removed.
}
  \item{tissueType}{Should be indicated as either 'tumour' or 'cells' depending on the sample type used.}
  \item{sampleNumber}{The number of samples on which you wish to perform the housekeeping normalisation.  The first n sample columns in the input file.}
}
\details{The RCC file that is output by the Nanostring nCounter software contains two empty rows when output.  These rows must be removed prior to analysis.  Multiple cartridges that use the same codeset can be merged together into a single file (there is no upper limit to sample size).  It is recommended that as many samples as possible are used to calculate the gene means for the housekeeping normalisation (12 samples is the recommended minimum).  If you add extra samples to an existing codeset/ analysis you will keep the sample gene means for housekeeping normalisation by adding the extra samples to the end of the same file and specifying the sample number the same as before.  The 'problem genes' matrix will tell you if the gene means are significantly different in your new samples.}
\value{
The function returns a list of matrices containing normalised log2 counts for both endogenous genes and for housekeepers - and (where additional samples have been added to an existing experiment/codeset) a matrix containing any genes where there is a significant difference at the housekeeping step.
  \item{Endogenous}{Matrix containing normalised log2 code counts in a gene by sample format}
  \item{Housekeeping}{Matrix containing log2 code counts in a gene by sample format}
  \item{WarningGenes}{Matrix containing genes significantly different to means and associated p value}
}

\author{
Mark Wappett
}

\examples{
# Read in RCC file and perform NAPPA normalisation
data(NAPPA_example_input)
output <- NAPPA(data=NAPPA_example_input, tissueType='tumour', sampleNumber=12)
}

\keyword{ Nanostring }
\keyword{ Normalisation }
