/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import java.util.Collection;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.similarity.AbstractItemSimilarity;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class CityBlockSimilarity
extends AbstractItemSimilarity
implements UserSimilarity {
    public CityBlockSimilarity(DataModel dataModel) {
        super(dataModel);
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        alreadyRefreshed = RefreshHelper.buildRefreshed(alreadyRefreshed);
        RefreshHelper.maybeRefresh(alreadyRefreshed, this.getDataModel());
    }

    @Override
    public double itemSimilarity(long itemID1, long itemID2) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int preferring1 = dataModel.getNumUsersWithPreferenceFor(itemID1);
        int preferring2 = dataModel.getNumUsersWithPreferenceFor(itemID2);
        int intersection = dataModel.getNumUsersWithPreferenceFor(itemID1, itemID2);
        return CityBlockSimilarity.doSimilarity(preferring1, preferring2, intersection);
    }

    @Override
    public double[] itemSimilarities(long itemID1, long[] itemID2s) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int preferring1 = dataModel.getNumUsersWithPreferenceFor(itemID1);
        double[] distance = new double[itemID2s.length];
        for (int i = 0; i < itemID2s.length; ++i) {
            int preferring2 = dataModel.getNumUsersWithPreferenceFor(itemID2s[i]);
            int intersection = dataModel.getNumUsersWithPreferenceFor(itemID1, itemID2s[i]);
            distance[i] = CityBlockSimilarity.doSimilarity(preferring1, preferring2, intersection);
        }
        return distance;
    }

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        int prefs2Size;
        DataModel dataModel = this.getDataModel();
        FastIDSet prefs1 = dataModel.getItemIDsFromUser(userID1);
        FastIDSet prefs2 = dataModel.getItemIDsFromUser(userID2);
        int prefs1Size = prefs1.size();
        int intersectionSize = prefs1Size < (prefs2Size = prefs2.size()) ? prefs2.intersectionSize(prefs1) : prefs1.intersectionSize(prefs2);
        return CityBlockSimilarity.doSimilarity(prefs1Size, prefs2Size, intersectionSize);
    }

    private static double doSimilarity(int pref1, int pref2, int intersection) {
        int distance = pref1 + pref2 - 2 * intersection;
        return 1.0 / (1.0 + (double)distance);
    }
}

