/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.myrrix.common.ClassUtils;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.LinearSystemSolver;
import net.myrrix.common.math.SimpleVectorMath;
import net.myrrix.common.math.Solver;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class MatrixUtils {
    private static final int PRINT_COLUMN_WIDTH = 12;
    private static final Field MATRIX_DATA_FIELD = ClassUtils.loadField(Array2DRowRealMatrix.class, "data");
    private static final LinearSystemSolver MATRIX_INVERTER;

    private MatrixUtils() {
    }

    public static void addTo(long row, long column, float value, FastByIDMap<FastByIDFloatMap> RbyRow, FastByIDMap<FastByIDFloatMap> RbyColumn) {
        MatrixUtils.addToByRow(row, column, value, RbyRow);
        MatrixUtils.addToByRow(column, row, value, RbyColumn);
    }

    private static void addToByRow(long row, long column, float value, FastByIDMap<FastByIDFloatMap> RbyRow) {
        FastByIDFloatMap theRow = RbyRow.get(row);
        if (theRow == null) {
            theRow = new FastByIDFloatMap();
            RbyRow.put(row, theRow);
        }
        theRow.increment(column, value);
    }

    public static void remove(long row, long column, FastByIDMap<FastByIDFloatMap> RbyRow, FastByIDMap<FastByIDFloatMap> RbyColumn) {
        MatrixUtils.removeByRow(row, column, RbyRow);
        MatrixUtils.removeByRow(column, row, RbyColumn);
    }

    private static void removeByRow(long row, long column, FastByIDMap<FastByIDFloatMap> RbyRow) {
        FastByIDFloatMap theRow = RbyRow.get(row);
        if (theRow != null) {
            theRow.remove(column);
            if (theRow.isEmpty()) {
                RbyRow.remove(row);
            }
        }
    }

    public static boolean isNonSingular(RealMatrix M) {
        return MATRIX_INVERTER.isNonSingular(M);
    }

    public static Solver getSolver(RealMatrix M) {
        return MATRIX_INVERTER.getSolver(M);
    }

    public static FastByIDMap<float[]> multiply(RealMatrix M, FastByIDMap<float[]> S) {
        FastByIDMap<float[]> result = new FastByIDMap<float[]>(S.size(), 1.25f);
        double[][] matrixData = MatrixUtils.accessMatrixDataDirectly(M);
        for (FastByIDMap.MapEntry<float[]> entry : S.entrySet()) {
            result.put(entry.getKey(), MatrixUtils.matrixMultiply(matrixData, entry.getValue()));
        }
        return result;
    }

    public static RealMatrix multiplyXYT(FastByIDMap<float[]> X, FastByIDMap<float[]> Y) {
        int Ysize = Y.size();
        int Xsize = X.size();
        Array2DRowRealMatrix result = new Array2DRowRealMatrix(Xsize, Ysize);
        for (int row = 0; row < Xsize; ++row) {
            for (int col = 0; col < Ysize; ++col) {
                result.setEntry(row, col, SimpleVectorMath.dot(X.get(row), Y.get(col)));
            }
        }
        return result;
    }

    public static double[][] accessMatrixDataDirectly(RealMatrix matrix) {
        try {
            return (double[][])MATRIX_DATA_FIELD.get(matrix);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException(iae);
        }
    }

    public static double[] multiply(RealMatrix matrix, float[] V) {
        double[][] M = MatrixUtils.accessMatrixDataDirectly(matrix);
        int rows = M.length;
        int cols = V.length;
        double[] out = new double[rows];
        for (int i = 0; i < rows; ++i) {
            double total = 0.0;
            double[] matrixRow = M[i];
            for (int j = 0; j < cols; ++j) {
                total += (double)V[j] * matrixRow[j];
            }
            out[i] = total;
        }
        return out;
    }

    private static float[] matrixMultiply(double[][] M, float[] V) {
        int rows = M.length;
        int cols = V.length;
        float[] out = new float[rows];
        for (int i = 0; i < rows; ++i) {
            double total = 0.0;
            double[] matrixRow = M[i];
            for (int j = 0; j < cols; ++j) {
                total += (double)V[j] * matrixRow[j];
            }
            out[i] = (float)total;
        }
        return out;
    }

    public static RealMatrix transposeTimesSelf(FastByIDMap<float[]> M) {
        if (M == null || M.isEmpty()) {
            return null;
        }
        Array2DRowRealMatrix result = null;
        for (FastByIDMap.MapEntry<float[]> entry : M.entrySet()) {
            float[] vector = entry.getValue();
            int dimension = vector.length;
            if (result == null) {
                result = new Array2DRowRealMatrix(dimension, dimension);
            }
            for (int row = 0; row < dimension; ++row) {
                float rowValue = vector[row];
                for (int col = 0; col < dimension; ++col) {
                    result.addToEntry(row, col, rowValue * vector[col]);
                }
            }
        }
        Preconditions.checkNotNull(result);
        return result;
    }

    public static String matrixToString(FastByIDMap<FastByIDFloatMap> M) {
        long[] rowKeys;
        StringBuilder result = new StringBuilder();
        long[] colKeys = MatrixUtils.unionColumnKeysInOrder(M);
        MatrixUtils.appendWithPadOrTruncate("", result);
        for (long colKey : colKeys) {
            result.append('\t');
            MatrixUtils.appendWithPadOrTruncate(colKey, result);
        }
        result.append("\n\n");
        for (long rowKey : rowKeys = MatrixUtils.keysInOrder(M)) {
            MatrixUtils.appendWithPadOrTruncate(rowKey, result);
            FastByIDFloatMap row = M.get(rowKey);
            for (long colKey : colKeys) {
                result.append('\t');
                float value = row.get(colKey);
                if (Float.isNaN(value)) {
                    MatrixUtils.appendWithPadOrTruncate("", result);
                    continue;
                }
                MatrixUtils.appendWithPadOrTruncate(value, result);
            }
            result.append('\n');
        }
        result.append('\n');
        return result.toString();
    }

    private static long[] keysInOrder(FastByIDMap<?> map) {
        FastIDSet keys = new FastIDSet(map.size(), 1.25f);
        LongPrimitiveIterator it = map.keySetIterator();
        while (it.hasNext()) {
            keys.add(it.nextLong());
        }
        long[] keysArray = keys.toArray();
        Arrays.sort(keysArray);
        return keysArray;
    }

    private static long[] unionColumnKeysInOrder(FastByIDMap<FastByIDFloatMap> M) {
        FastIDSet keys = new FastIDSet(1000, 1.25f);
        for (FastByIDMap.MapEntry<FastByIDFloatMap> entry : M.entrySet()) {
            LongPrimitiveIterator it = entry.getValue().keySetIterator();
            while (it.hasNext()) {
                keys.add(it.nextLong());
            }
        }
        long[] keysArray = keys.toArray();
        Arrays.sort(keysArray);
        return keysArray;
    }

    private static void appendWithPadOrTruncate(long value, StringBuilder to) {
        MatrixUtils.appendWithPadOrTruncate(Long.toString(value), to);
    }

    private static void appendWithPadOrTruncate(float value, StringBuilder to) {
        String stringValue = Float.toString(value);
        if (value >= 0.0f) {
            stringValue = ' ' + stringValue;
        }
        MatrixUtils.appendWithPadOrTruncate(stringValue, to);
    }

    private static void appendWithPadOrTruncate(CharSequence value, StringBuilder to) {
        int length = value.length();
        if (length >= 12) {
            to.append(value, 0, 12);
        } else {
            for (int i = length; i < 12; ++i) {
                to.append(' ');
            }
            to.append(value);
        }
    }

    static {
        String lssClassName = Boolean.parseBoolean(System.getProperty("common.matrix.nativeMath", "false")) ? "net.myrrix.common.math.JBlasLinearSystemSolver" : "net.myrrix.common.math.CommonsMathLinearSystemSolver";
        MATRIX_INVERTER = ClassUtils.loadInstanceOf(lssClassName, LinearSystemSolver.class);
    }
}

