/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import java.io.File;

public final class RunnerConfiguration {
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_SECURE_PORT = 443;
    public static final String AUTO_PARTITION_SPEC = "auto";
    private String bucket;
    private String instanceID;
    private int port = 80;
    private int securePort = 443;
    private String contextPath;
    private boolean readOnly;
    private File keystoreFile;
    private String keystorePassword;
    private File localInputDir;
    private String userName;
    private String password;
    private boolean consoleOnlyPassword;
    private Integer hostRequestLimit;
    private String rescorerProviderClassName;
    private String clientThreadClassName;
    private Integer partition;
    private String allPartitionsSpecification;

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        Preconditions.checkArgument(port >= 0, "port must be nonnegative: %s", port);
        this.port = port;
    }

    public int getSecurePort() {
        return this.securePort;
    }

    public void setSecurePort(int securePort) {
        Preconditions.checkArgument(securePort >= 0, "securePort must be nonnegative: %s", securePort);
        this.securePort = securePort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        if (contextPath != null && !contextPath.startsWith("/")) {
            contextPath = '/' + contextPath;
        }
        this.contextPath = contextPath;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public File getLocalInputDir() {
        return this.localInputDir;
    }

    public void setLocalInputDir(File localInputDir) {
        this.localInputDir = localInputDir;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isConsoleOnlyPassword() {
        return this.consoleOnlyPassword;
    }

    public void setConsoleOnlyPassword(boolean consoleOnlyPassword) {
        this.consoleOnlyPassword = consoleOnlyPassword;
    }

    public Integer getHostRequestLimit() {
        return this.hostRequestLimit;
    }

    public void setHostRequestLimit(Integer hostRequestLimit) {
        this.hostRequestLimit = hostRequestLimit;
    }

    public String getRescorerProviderClassName() {
        return this.rescorerProviderClassName;
    }

    public void setRescorerProviderClassName(String rescorerProviderClassName) {
        this.rescorerProviderClassName = rescorerProviderClassName;
    }

    public String getClientThreadClassName() {
        return this.clientThreadClassName;
    }

    public void setClientThreadClassName(String clientThreadClassName) {
        this.clientThreadClassName = clientThreadClassName;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        if (partition != null) {
            Preconditions.checkArgument(partition >= 0, "Partition should be at least 0");
        }
        this.partition = partition;
    }

    public String getAllPartitionsSpecification() {
        return this.allPartitionsSpecification;
    }

    public void setAllPartitionsSpecification(String allPartitionsSpecification) {
        this.allPartitionsSpecification = allPartitionsSpecification;
    }
}

