% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MvBinaryEstim.R
\name{MvBinaryEstim}
\alias{MvBinaryEstim}
\title{Create an instance of the [\code{\linkS4class{MvBinaryResult}}] class}
\usage{
MvBinaryEstim(x, nbcores = 1, algorithm = "HAC", modelslist = NULL,
  tol.EM = 0.01, nbinit.EM = 40, nbiter.MH = 50, nbchains.MH = 10)
}
\arguments{
\item{x}{matrix of the binary observation.}

\item{nbcores}{number of cores used for the model selection (only for Linux). Default is 1.}

\item{algorithm}{algorithm used for the model selection ("HAC": deterministic algorithm based on the HAC of the variables, "MH": stochastic algorithm for optimizing the BIC criterion, "List": comparison of the models provided by the users). Default is "HAC".}

\item{modelslist}{list of models provided by the user (only used when algorithm="List"). Default is NULL}

\item{tol.EM}{stopping criterion for the EM algorithm. Default is 0.01}

\item{nbinit.EM}{number of random initializations for the EM algorithm. Default is 40.}

\item{nbiter.MH}{number of successive iterations without finding a model having a better BIC criterion which involves the stopping of the Metropolis-Hastings algorithm (only used when algorithm="MH"). Default is 50.}

\item{nbchains.MH}{number of radom initializations for the stochastic algorithm (only used when algorithm="MH"). Default is 10.}
}
\value{
Returns an instance of the [\code{\linkS4class{MvBinaryResult}}] class.
}
\description{
This function performs the model selection and the parameter inference.
}
\examples{
# Data loading
data(MvBinaryExample)

# Parameter estimation by the HAC-based algorithm on 2 cores
# where the EM algorithms are initialized 10 times
res.CAH <- MvBinaryEstim(MvBinaryExample, 2, nbinit.EM = 10)

# Parameter estimation for two competing models
res.CAH <- MvBinaryEstim(MvBinaryExample, algorithm="List",
 modelslist=list(c(1,1,2,2,3,4), c(1,1,1,2,2,2)), nbinit.EM = 10)

# Summary of the estimated model
summary(res.CAH)

# Print the parameters of the estimated model
print(res.CAH)
}

