% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spliting.R
\name{spliting}
\alias{spliting}
\title{Split of the Parent node}
\usage{
spliting(X, Y, mtree, Index, V_inv, Command)
}
\arguments{
\item{X}{Input Training matrix of M x N, M is the number of training samples and N is the number of features}

\item{Y}{Output Training response of M x T, M is the number of samples and T is number of ouput Features(Response)}

\item{mtree}{number of randomly selected features used for each split}

\item{Index}{Index of training samples}

\item{V_inv}{Covariance matrix of Output Feature matrix}

\item{Command}{1 for RF and 2 for MRF depending on the method}
}
\value{
List with the following components:
\item{index_left}{Index of the samples which are in the left node after splitting}
\item{index_right}{Index of the samples which are in the right node after splitting}
\item{which_feature}{The number of the feature which gives the minimum splitting cost}
\item{threshold_feature}{The threshold value, which will decide a sample will go to the left node or,
right node. If the training sample value is less than threshold value, it will go to the left node or if greater
then go to the right node.}
}
\description{
Split of the training samples of the parent node into the child node 
for the feature which gives the minimum cost of splitting
}
\details{
In a node of a decision tree, there are number of samples with different features. In time of splitting, a fixed number
of features(mtree) has been selected randomly(that's why it is called random forest). For the splitting, node cost 
for all the spliting of these features are considered and whichever gives the minimum value has been selected as 
the splitting criteria(feature value and threshold value of the feature) of this node split.
}
\examples{
X=matrix(runif(20*100),20,100)
Y=matrix(runif(20*3),20,3)
mtree=5
Index=1:20
V_inv=stats::cov(Y)
Command=2#MRF, as number of output feature is greater than 1
Split_criteria=spliting(X,Y,mtree,Index,V_inv,Command) 
}

