% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VRM.R
\name{VRM}
\alias{VRM}
\title{Implementation of the Sappington et al., (2007) vector ruggedness measure}
\usage{
VRM(
  r,
  w = c(3, 3),
  na.rm = FALSE,
  include_scale = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{DTM as a SpatRaster or RasterLayer}

\item{w}{A vector of length 2 specifying the dimensions of the rectangular window to use where the first number is the number of rows and the second number is the number of columns. Window size must be an odd number. Default is 3x3.}

\item{na.rm}{A logical indicating whether or not to remove NA values before calculations}

\item{include_scale}{logical indicating whether to append window size to the layer names (default = FALSE)}

\item{filename}{character Output filename.}

\item{overwrite}{logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{list with named options for writing files as in writeRaster}
}
\value{
a RasterLayer
}
\description{
Implementation of the Sappington et al., (2007) vector ruggedness measure, modified from Evans (2021).
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + 
ncol(volcano)*10, 6478700, 6478700 + nrow(volcano)*10), 
crs = "EPSG:27200")
vrm<- VRM(r, w=c(5,5), na.rm = TRUE)
plot(vrm)
}
\references{
Evans JS (2021). spatialEco. R package version 1.3-6, https://github.com/jeffreyevans/spatialEco.

Sappington, J.M., Longshore, K.M., Thompson, D.B., 2007. Quantifying Landscape Ruggedness for Animal Habitat Analysis: A Case Study Using Bighorn Sheep in the Mojave Desert. The Journal of Wildlife Management 71, 1419-1426. https://doi.org/10.2193/2005-723
}
