% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPI.R
\name{TPI}
\alias{TPI}
\title{Calculates Topographic Position Index}
\usage{
TPI(
  r,
  w = dplyr::case_when(tolower(shape) == "rectangle" ~ 3, tolower(shape) == "circle" &
    isTRUE(tolower(unit) == "cell") ~ 1, tolower(shape) == "circle" &
    isTRUE(tolower(unit) == "map") ~ max(terra::res(r))),
  shape = "rectangle",
  stand = "none",
  unit = "cell",
  na.rm = FALSE,
  include_scale = FALSE,
  filename = NULL,
  overwrite = FALSE,
  wopt = list()
)
}
\arguments{
\item{r}{DTM as a SpatRaster or RasterLayer. TPI calls the function RelPos internally which serves as a general purpose and more flexible function for calculating relative position.}

\item{w}{For a "rectangle" focal window, a vector of length 2 containing odd numbers specifying dimensions where the first number is the number of rows and the second is the number of columns (or a single number if the number of rows and columns is equal). For a "circle" shaped focal window, a single integer representing the radius in "cell" or "map" units or a focal weights matrix created by MultiscaleDTM::circle_window.}

\item{shape}{Character representing the shape of the focal window. Either "rectangle" (default) or "circle".}

\item{stand}{Standardization method. Either "none" (the default), "range" or "sd" indicating whether the TPI should be standardized by dividing by the standard deviation or range of included values in the focal window. If stand is 'none' the layer name will be "tpi", otherwise it will be "stpi" to indicate that the layer has been standardized.}

\item{unit}{Unit for w if shape is 'circle' and it is a vector (default is unit="cell"). For circular windows specified with a matrix, unit is ignored and extracted directly from w. For rectangular and custom focal windows set unit='cell' or set unit to NA/NULL.}

\item{na.rm}{Logical indicating whether or not to remove NA values before calculations.}

\item{include_scale}{Logical indicating whether to append window size to the layer names (default = FALSE) or a character vector specifying the name you would like to append or a number specifying the number of significant digits. If include_scale = TRUE the number of rows and number of columns will be appended for rectangular windows. For circular windows it will be a single number representing the radius. If unit="map" then window size will have "MU" after the number indicating that the number represents the scale in map units (note units can be extracted from w created with MultiscaleDTM::circle_window).}

\item{filename}{Character output filename.}

\item{overwrite}{Logical. If TRUE, filename is overwritten (default is FALSE).}

\item{wopt}{List with named options for writing files as in writeRaster.}
}
\value{
SpatRaster or RasterLayer.
}
\description{
Calculates Topographic Position Index (TPI). TPI is a measure of relative position that calculates the the difference between the value of the focal cell and the mean of mean of the surrounding cells (i.e. local mean but excluding the value of the focal cell).Positive values indicate local highs (i.e. peaks) and negative values indicate local lows (i.e. depressions). TPI can be expressed in units of the input DTM raster or can standardized relative to the local topography by dividing by the standard deviation or range of included elevation  values in the focal window.
}
\examples{
r<- rast(volcano, extent= ext(2667400, 2667400 + 
ncol(volcano)*10, 6478700, 6478700 + nrow(volcano)*10), 
crs = "EPSG:27200")
tpi<- TPI(r, w=c(5,5), shape="rectangle", stand="none", na.rm = TRUE)
plot(tpi)
}
\references{
Weiss, A., 2001. Topographic Position and Landforms Analysis. Presented at the ESRI user conference, San Diego, CA.
}
