% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_UnivMomCum}
\alias{indx_UnivMomCum}
\title{Univariate moments and cumulants from T-vectors}
\usage{
indx_UnivMomCum(d, q)
}
\arguments{
\item{d}{dimension of a vector X}

\item{q}{power of the Kronecker product}
}
\value{
A vector of indexes
}
\description{
A vector of indexes to select the moments and cumulants of the single components
of the random vector X for which a T-vector of moments and cumulants is available
}
\examples{
## For a 3-variate skewness and kurtosis vectors estimated from data, extract
## the skewness and kurtosis estimates for each of the single components of the vector
alpha<-c(10,5,0)
omega<-diag(rep(1,3))
X<-distr_SkewNorm_Rand(200, omega, alpha)
EVSK<-Esti_EVSK(X)
## Get the univariate skewness and kurtosis for X1,X2,X3
EVSK$estSkew[indx_UnivMomCum(3,3)]
EVSK$estKurt[indx_UnivMomCum(3,4)]
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Elimination}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
