% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Commutators.R
\name{indx_Elimination}
\alias{indx_Elimination}
\title{Distinct values selection vector}
\usage{
indx_Elimination(d, q)
}
\arguments{
\item{d}{dimension of a vector x}

\item{q}{power of the Kronecker product}
}
\value{
A vector of indexes of the distinct elements in the T-vector
}
\description{
Eliminates the duplicated/q-plicated elements in a T-vector of multivariate moments
and cumulants. Produces the same results as matr_Elimination.
Note indx_Elimination does not provide the same results as unique()
}
\examples{
x<-c(1,0,3)
y<-kronecker(x,kronecker(x,x))
y[indx_Elimination(3,3)]
## Not the same results as
unique(y)

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section  1.3.2 Multi-Indexing, Elimination, and Duplication, p.21,(1.32)
}
\seealso{
Other Matrices and commutators: 
\code{\link{indx_Commutator_Kmn}()},
\code{\link{indx_Commutator_Kperm}()},
\code{\link{indx_Commutator_Mixing}()},
\code{\link{indx_Commutator_Moment}()},
\code{\link{indx_Qplication}()},
\code{\link{indx_Symmetry}()},
\code{\link{indx_UnivMomCum}()},
\code{\link{matr_Commutator_Kmn}()},
\code{\link{matr_Commutator_Kperm}()},
\code{\link{matr_Commutator_Mixing}()},
\code{\link{matr_Commutator_Moment}()},
\code{\link{matr_Elimination}()},
\code{\link{matr_Qplication}()},
\code{\link{matr_Symmetry}()}
}
\concept{Matrices and commutators}
