% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.r
\name{Partition_Type_All}
\alias{Partition_Type_All}
\title{Partitions, type and number of partitions}
\usage{
Partition_Type_All(N)
}
\arguments{
\item{N}{The (integer) number of elements to be partitioned}
}
\value{
\code{Part.class} The list of all possible partitions given as partition matrices

\code{S_N_r}  A vector with the number of partitions of size r=1, r=2, etc. (Stirling numbers of second kind )

\code{eL_r}  A list of partition types with respect to partitions of size r=1, r=2, etc.

\code{S_r_j} Vectors of number of partitions with given types grouped by partitions of size r=1, r=2, etc.
}
\description{
Generates all partitions of \code{N} numbers and classify them by type
}
\examples{
# See Example 1.18, p. 32, reference below
PTA<-Partition_Type_All(4)
# Partitions generated
PTA$Part.class
# Partitions of size 2 includes two types
PTA$eL_r[[2]]
# Number of partitions with r=1 blocks, r=2 blocks, etc-
PTA$S_N_r
# Number of different types collected by  partitions of size r=1, r=2, etc.
PTA$S_r_j
# Partitions with size r=2, includes two types (above) each with number
PTA$S_r_j[[2]]

}
\references{
Gy. Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Case 1.4, p.31 and Example 1.18, p.32.
}
\seealso{
Other Partitions: 
\code{\link{Partition_2Perm}()},
\code{\link{Partition_Indecomposable}()},
\code{\link{Partition_Pairs}()},
\code{\link{Permutation_Inverse}()}
}
\concept{Partitions}
