% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hermite.r
\name{Hermite_Poly_HN}
\alias{Hermite_Poly_HN}
\title{Univariate Hermite polynomials}
\usage{
Hermite_Poly_HN(x, N, sigma2 = 1)
}
\arguments{
\item{x}{A scalar at which to evaluate the Hermite polynomials}

\item{N}{The maximum order of the polynomials}

\item{sigma2}{The variance, by default is set to 1}
}
\value{
\code{H_N_x} The vector of Hermite polynomials with degrees  from 1 to N evaluated at x
}
\description{
Provides the vector of univariate Hermite polynomials up to order N evaluated at x
}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021.  Section 4.1
}
\seealso{
Other Hermite: 
\code{\link{Hermite_CoeffMulti}()},
\code{\link{Hermite_Coeff}()},
\code{\link{Hermite_N_Cov_X1_X2}()},
\code{\link{Hermite_Nth}()},
\code{\link{Hermite_Poly_HN_Multi}()},
\code{\link{Hermite_Poly_NH_Inv}()},
\code{\link{Hermite_Poly_NH_Multi_Inv}()}
}
\concept{Hermite}
