% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{generateBalanceTable}
\alias{generateBalanceTable}
\title{Generate balance table}
\usage{
generateBalanceTable(
  matchingResult,
  covList = NULL,
  display.all = TRUE,
  statList = c("mean.diffs")
)
}
\arguments{
\item{matchingResult}{an object returned by the main matching function
distBalMatch}

\item{covList}{(optional) a vector of names of covariates used for evaluating
covariate imbalance; NULL by default.}

\item{display.all}{(optional) a boolean value indicating whether or not to
show the data for all possible matches; TRUE by default}

\item{statList}{(optional) a vector of statistics that are calculated for
evaluating the covariate imbalance between treated and control group. The
types that are supported can be found here: \link[cobalt]{bal.tab}.}
}
\value{
a named list object containing covariate balance table and statistics
for numer of units being matched for each match; the names are the
character of index for each match in the \code{matchResult}.
}
\description{
The helper function can generate tabular analytics that quantify
covariate imbalance after matching. It only works for the 'Basic' version of
matching (produced by \code{distBalMatch}).
}
\details{
The result can be either directly used by indexing into the list, or
post-processing by the function \code{compareTables} that summarizes the
covariate balance information in a tidier table. Users can specify the
arguments as follows: * \code{covList}: if it is set of NULL, all the covariates
are included for the covariate balance table; otherwise, only the specified
covariates will be included in the tabular result. * \code{display.all}: by
default, the summary statistics for each match are included when the
argument is set to TRUE. If the user only wants to see the summary
statistics for matches with varying performance on three different
objective values, the function would only display the matches with number
of treated units being excluded at different quantiles. User can switch to
the brief version by setting the parameter to FALSE. * \code{statList} is the
list of statistics used for measuring balance. The argument is the same as
\code{stats} argument in \link[cobalt]{bal.tab}, which is the function that is
used for calculating the statistics. By default, only standardized
difference in means is calculated.
}
\examples{
## Generate matches
data("lalonde", package="cobalt")
psCols <- c("age", "educ", "married", "nodegree")
treatVal <- "treat"
responseVal <- "re78"
pairDistVal <- c("age", "married", "educ", "nodegree")
exactVal <- c("educ")
myBalVal <- c("race")
r1s <- c( 0.1, 0.3, 0.5, 0.7, 0.9,1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7)
r2s <- c(0.01)
matchResult <- distBalMatch(df=lalonde, treatCol=treatVal, myBalCol=myBalVal,
rhoExclude =r1s, rhoBalance=r2s,
distList=pairDistVal, exactlist=exactVal,
propensityCols = psCols,ignore = c(responseVal), maxUnMatched = 0.1,
caliperOption=NULL, toleranceOption=1e-1, maxIter=0, rho.max.f = 10)

## Generate summary table for balance 
balanceTables <- generateBalanceTable(matchResult)
balanceTableMatch10 <- balanceTables$'10'
}
\seealso{
Other numerical analysis helper functions: 
\code{\link{generateRhoObj}()},
\code{\link{getUnmatched}()}
}
\concept{numerical analysis helper functions}
