% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Test_aSPA.R
\name{Test_aSPA}
\alias{Test_aSPA}
\title{Test average Superior Predictive Ability}
\usage{
Test_aSPA(LossDiff, weights, L, B = 999)
}
\arguments{
\item{LossDiff}{the T x H matrix forecast path loss differential}

\item{weights}{the 1 x H vector of weights for the losses at different horizons. For instance \code{weights <- matlab::ones(1,20)/20}}

\item{L}{integer, the parameter for the moving block bootstrap}

\item{B}{integer, the number of bootstrap iterations. Default 999}
}
\value{
A list containing two objects:
\item{"p_value"}{the p-value for aSPA}
\item{"t_aSPA"}{the statistics for aSPA}
}
\description{
Implements the test for average Superior Predictive Ability (aSPA) of Quaedvlieg (2021)
}
\examples{
## Test for aSPA and uSPA
data(LossDiff_aSPA)
weights <- matlab::ones(1,20)/20
Test_aSPA(LossDiff=LossDiff_aSPA, weights=weights, L=3, B=10)

}
\references{
Quaedvlieg, Rogier. "Multi-horizon forecast comparison." Journal of Business & Economic Statistics 39.1 (2021): 40-53.
}
\seealso{
\code{\link{Test_uSPA}}
}
\author{
Luca Barbaglia \url{https://lucabarbaglia.github.io/}
}
