% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiFit.R
\name{multiFit}
\alias{multiFit}
\title{Multiscale Multivariate Framework for Independence Tests}
\usage{
multiFit(xy, x = NULL, y = NULL, M = 10L, max.res = NULL,
  full.coverage.res = NULL, rank.transform = TRUE, test.method = "Fisher",
  correct = TRUE, min.win.tot = 25L, min.row.tot = 10L,
  min.col.tot = 10L, p.adjust.methods = c("H", "Hcorrected", "MH"),
  compute.all.holm = TRUE, cutoff = 0.05, top.max.ps = 4L,
  return.all.pvs = TRUE, save.all.pvs = FALSE, all.pvs.fname = NULL,
  uv.approx.null = FALSE, uv.exact.null = FALSE, uv.null.sim = 10000L,
  plot.marginals = FALSE, verbose = FALSE)
}
\arguments{
\item{xy}{A list, whose first element corresponds to the matrix x as below, and
its second element corresponds to the matrix y as below. If \code{xy} is not
specified, \code{x} and \code{y} need to be assigned.}

\item{x}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{y}{A matrix, number of columns = dimension of random vector,
number of rows = number of observations.}

\item{M}{A positive integer (or Inf), the number of top ranking
windows to continue to test at each resolution.}

\item{max.res}{A positive integer (or Inf), the maximal number of
resolutions to scan (algorithm will stop at a lower resolution if
all windows in it do not meet the criteria specified at min.win.tot,
min.row.tot and min.col.tot)}

\item{full.coverage.res}{A positive integer, if set to an integer
between 0 and \code{max.res}, all tests up to and including resolution \code{full.coverage.res}
will be performed (algorithm will stop at a lower resolution than requested if
all windows in it do not meet the criteria specified at min.win.tot,
min.row.tot and min.col.tot). For higher resolutions the children of the
top \code{M} ranking windows will be selected.}

\item{rank.transform}{Logical, if \code{TRUE}, marginal rank transform is
performed on all margins of \code{x} and \code{y}. If \code{FALSE}, all
margins are scaled to 0-1 scale. When \code{FALSE}, the average and top
statistics of the negative logarithm of the \code{p}-values are only computed
for the univariate case.}

\item{test.method}{String, choose "Fisher" for Fisher's exact test (slowest), "chi.sq" for
Chi-squared test, "LR" for likelihood-ratio test and "norm.approx" for approximating
the hypergeometric distribution with a normal distribution (fastest).}

\item{correct}{Logical, if \code{TRUE} compute mid-p corrected \code{p}-values for
Fisher's exact test, or Yates corrected \code{p}-values for the Chi-squared test,
or Williams corrected \code{p}-values for the likelihood-ratio test.}

\item{min.win.tot}{Non-negative integer, the minimal number of observations
per window below which a \code{p}-value for a given window will not be computed.}

\item{min.row.tot}{Non-negative integer, the minimal number of observations
for row totals in the 2x2 contingency tables below which a contingency table will not be tested.}

\item{min.col.tot}{Non-negative integer, the minimal number of observations
for column totals in the 2x2 contingency tables below which a contingency table will not be tested.}

\item{p.adjust.methods}{String, choose between "H" for Holm, "Hcorrected" for Holm with
the correction as specified in \code{correct}, or "MH" for Modified-Holm (for Fisher's
exact test only). See documentation for further details.}

\item{compute.all.holm}{Logical, if \code{FALSE}, only global \code{p}-value is
computed (may be faster, especially when Modified-Holm correction is used). If \code{TRUE}
adjusted \code{p}-values are computed for all tests.}

\item{cutoff}{Numerical between 0 and 1, an upper limit for the \code{p}-values
that are to be adjusted (the lower the cutoff - the fewer computations are required
for the Modified Holm method).}

\item{top.max.ps}{Positive integer, report the mean of the top \code{top.max.ps}
order statistics of the negative logarithm of all \code{p}-values.}

\item{return.all.pvs}{Logical, if TRUE, a data frame with all \code{p}-values
is returned.}

\item{save.all.pvs}{Logical, if \code{TRUE} a data frame with all \code{p}-values
is saved to a RData file named according to \code{all.pvs.fname}}

\item{all.pvs.fname}{String, file name to which all \code{p}-values are saved if
\code{save.all.pvs} is \code{TRUE}.}

\item{uv.approx.null}{Logical, in a univariate case, if \code{TRUE} and the
testing method is either Fisher's exact test or the normal approximation of
the hypergeometric distribution, an approximate null distribution for the global
test statistics is simulated. See documentation for further details.}

\item{uv.exact.null}{Logical, in a univariate case, if \code{TRUE} and the
testing method is either Fisher's exact test or the normal approximation of
the hypergeometric distribution, an exact null distribution for the global
test statistics is simulated. See documentation for further details.}

\item{uv.null.sim}{Positive integer, the number of simulated values to be computed
in a univariate case when an exact or approximate null distribution is simulated.}

\item{plot.marginals}{Logical, if \code{TRUE} plots the marginal scatter plots between
all pairs of margins of x and y, before and after rank transforming or scaling them.}

\item{verbose}{Logical.}
}
\value{
\code{test.stats}, a named numerical vector containing the test
statistics for the global null hypothesis (i.e. x independent of y)

\code{p.values}, a named numerical vector containing the \code{p}-values of
for the global null hypothesis (i.e. x independent of y). These are not computed
if \code{p.adjust.methods} is \code{NULL}.

\code{pvs}, a data frame that contains all \code{p}-values and adjusted
\code{p}-values that are computed. Returned if \code{return.all.pvs} is \code{TRUE}.

\code{R}, a nested list. Each entry is named and contains data about a resolution
that was tested. Each resolution is a list in itself, with \code{wins}, a summary of
all tested windows in a resolution, \code{tables}, a summary of all 2x2
contingency tables in a resolution, \code{pv}, a numerical vector containing the
\code{p}-values from the tests of independence on 2x2 contingency table in \code{tables}
that meet the criteria defined by \code{min.win.tot}, \code{min.row.tot} and \code{min.col.tot}.
The length of \code{pv} is equal to the number of rows of \code{tables}. \code{pv.correct},
similar to the above \code{pv}, corrected \code{p}-values are computed and returned when
\code{correct} is \code{TRUE}. \code{rank.tests}, logical vector that indicates
whether or not a test was ranked among the top \code{M} tests in a resolution. The
length of \code{rank.tests} is equal to the number of rows of \code{tables}. \code{parent.wins},
an integer vector, indicating which windows in a resolution are associated with
the ranked tests, and will be further halved in the next higher resolution (same windows may
have multiple children). \code{parent.tests}, a logical vector of the same length as the
number of rows of \code{tables}, indicating whether or not a test was chosen as a parent
test (same tests may have multiple children).

\code{approx.nulls}, in a univariate case, a list of numerical vectors
whose values are the simulated approximate null values.

\code{exact.nulls}, in a univariate case, a list of numerical vectors
whose values are the simulated theoretical null values.
}
\description{
Perform multiscale test of independence for multivariate vectors.
See vignettes for further examples.
}
\examples{
set.seed(1)
n = 300
d1 = d2 = 2
x = matrix(0, nrow=n, ncol=d1)
y = matrix(0, nrow=n, ncol=d2)
x[,1] = rnorm(n)
x[,2] = runif(n)
y[,1] = rnorm(n)
y[,2] = sin(5*pi*x[,2]) + 1/5*rnorm(n)
fit = multiFit(x=x, y=y, verbose=TRUE)
w = multiSummary(x=x, y=y, fit=fit, alpha=0.0001)
}
