% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastYields.R
\name{ForecastYields}
\alias{ForecastYields}
\title{Generates forecasts of bond yields for all model types}
\usage{
ForecastYields(
  ModelType,
  ModelPara,
  InputsForOutputs,
  FactorLabels,
  Economies,
  JLLlist = NULL,
  GVARlist = NULL,
  WishBRW = FALSE,
  BRWlist = NULL,
  Folder2save = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{ModelPara}{list. Point estimates of the model parameters. See outputs from \code{\link{Optimization}}.}

\item{InputsForOutputs}{list. Inputs for generating IRFs, GIRFs, FEVDs, GFEVDs, and Term Premia.}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{JLLlist}{list. Inputs for JLL model estimation (see \code{\link{JLL}}). Default is NULL.}

\item{GVARlist}{list. Inputs for GVAR model estimation (see \code{\link{GVAR}}). Default is NULL.}

\item{WishBRW}{logical. Whether to estimate the physical parameter model with bias correction (see \code{\link{Bias_Correc_VAR}}). Default is FALSE.}

\item{BRWlist}{list. Inputs for bias-corrected estimation (see \code{\link{Bias_Correc_VAR}}).}

\item{Folder2save}{character. Folder path where outputs will be stored. Default saves outputs in a temporary directory.}

\item{verbose}{logical. Print progress messages. Default is TRUE.}
}
\value{
An object of class 'ATSMModelForecast' containing the following elements:
\enumerate{
  \item Out-of-sample forecasts of bond yields per forecast horizon
  \item Out-of-sample forecast errors of bond yields per forecast horizon
  \item Root mean square errors per forecast horizon
}
}
\description{
Generates forecasts of bond yields for all model types
}
\section{Permissible options - forecast list (\code{InputsForOutputs} input)}{

\itemize{
   \item \code{ForHoriz}: forecast horizon. Must be a positive integer.
   \item \code{t0Sample}:   initial sample date. Must be a positive integer smaller than the time series dimension of the model (\code{Td})
   \item \code{t0Forecast}:  last sample date for the first forecast. Note that \code{Td > t0Forecast + ForHoriz}.
   \item \code{ForType}: \code{"Rolling"} (rolling window forecast) or \code{"Expanding"} (for expanding window forecast)
}
}

\section{Available Methods}{

- `plot(object)`
}

\examples{
\donttest{
data("ParaSetEx")
data("InpForOutEx")
# Adjust inputs according to the loaded features
ModelType <- "JPS original"
Economy <- "Brazil"
FacLab <- LabFac(N = 1, DomVar = "Eco_Act", GlobalVar = "Gl_Eco_Act", Economy, ModelType)
 # Adjust Forecasting setting
InpForOutEx[[ModelType]]$Forecasting <- list(
  WishForecast = 1, ForHoriz = 12, t0Sample = 1,
  t0Forecast = 143, ForType = "Expanding"
)

Forecast <- ForecastYields(ModelType, ParaSetEx, InpForOutEx, FacLab, Economy,
  WishBRW = FALSE, verbose = TRUE
)
}
}
