% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLEdensity.R
\name{A0N_MLEdensity_WOE__jointQ_Bootstrap}
\alias{A0N_MLEdensity_WOE__jointQ_Bootstrap}
\title{Compute the maximum likelihood function (joint Q models) - Bootstrap version}
\usage{
A0N_MLEdensity_WOE__jointQ_Bootstrap(
  K1XQ,
  r0,
  SSZ,
  K0Z,
  K1Z,
  se,
  Gy.0,
  mat,
  Y,
  Z,
  P,
  Wpca,
  We,
  WpcaFull,
  dt,
  Economies,
  FactorLabels,
  ModelType,
  residBS,
  MaxEigen,
  GVARinputs,
  JLLinputs,
  nargout
)
}
\arguments{
\item{K1XQ}{risk-neutral feedback matrix (NxN)}

\item{r0}{long-run interest rate  (scalar)}

\item{SSZ}{variance-covariance matrix (KxK)}

\item{K0Z}{intercept from the P-dynamics (Kx1)}

\item{K1Z}{feedback matrix from the P-dynamics (KxK)}

\item{se}{Variance of the portfolio of yields observed with error (scalar)}

\item{Gy.0}{matrix of contemporaneous terms from the P-dynamics (KxK)}

\item{mat}{vector of maturities (in years) of yields used in estimation (J x 1)}

\item{Y}{matrix of yields used in estimation  (J x T)}

\item{Z}{complete set of spanned and unspanned factors (KxT)}

\item{P}{complete set of spanned factors (NxT)}

\item{Wpca}{matrix of weights of the portfolios observed without errors (NxJ)}

\item{We}{matrix of weights of the portfolios observed with errors ((J-N)xJ)}

\item{WpcaFull}{composite matrix of weights the portfolios observed with and without errors}

\item{dt}{time interval unit of the model (scalar). For instance, if data is (i) monthly, dt <- 12; (ii) quarterly, dt <- 4; (iii) yearly, dt <- 1.}

\item{Economies}{a string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{ModelType}{feasible options are (i) "VAR jointQ", (ii) "GVAR jointQ" or (iii) "JLL jointSigma"}

\item{residBS}{index of the re-ordered bootstrap residuals}

\item{MaxEigen}{largest eigenvalue under the P-dynamics}

\item{GVARinputs}{if the model chosen is the "GVAR sepQ", "GVARinputs" should be specified (see "GVAR" function )}

\item{JLLinputs}{if the model chosen is the "JLL jointSigma". "JLLinputs" should be specified (see "JLL" function)}

\item{nargout}{if nargout== 1: provides only the values of the likelihood; if nargout== 2: complete ATSM outputs}
}
\description{
Compute the maximum likelihood function (joint Q models) - Bootstrap version
}
\references{
This function is modified version of the "A0N_MLEdensity_WOE" function by Le and Singleton (2018).\cr
 "A Small Package of Matlab Routines for the Estimation of Some Term Structure Models." \cr
 (Euro Area Business Cycle Network Training School - Term Structure Modelling).
 Available at: https://cepr.org/40029
}
