% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareModels.R
\name{compareModels}
\alias{compareModels}
\title{Compare the output of two Mplus models}
\usage{
compareModels(m1, m2, show = "all", equalityMargin = c(param = 1e-04, pvalue
  = 1e-04), compare = "unstandardized", sort = "none", showFixed = FALSE,
  showNS = TRUE, diffTest = FALSE)
}
\arguments{
\item{m1}{The first Mplus model to be compared. Generated by \code{readModels},
\code{extractModelSummaries}, or \code{extractModelParameters}.}

\item{m2}{The second Mplus model to be compared.}

\item{show}{What aspects of the models should be compared. Options are
"all", "summaries", "equal", "diff", "pdiff", and "unique". See below for details.}

\item{equalityMargin}{Defines the discrepancy between models that is considered equal.
Different margins can be specified for p-value equality
versus parameter equality. Defaults to .0001 for both.}

\item{compare}{Which parameter estimates should be compared. Options are "unstandardized", "stdyx.standardized"
"stdy.standardized", and "std.standardized".}

\item{sort}{How to sort the output of parameter comparisons.
Options are "none", "type", "alphabetical", and "maxDiff". See below for details.}

\item{showFixed}{Whether to display fixed parameters in the output (identified
where the est/se = 999.000, per Mplus convention). Default to \code{FALSE}.}

\item{showNS}{Whether to display non-significant parameter estimates. Can be
  \code{TRUE} or \code{FALSE}, or a numeric value (e.g., .10) that defines
what p-value is filtered as non-significant.}

\item{diffTest}{Whether to compute a chi-square difference test between the models.
Assumes that the models are nested. Not available for MLMV, WLSMV, and ULSMV estimators.
Use DIFFTEST in Mplus instead.}
}
\value{
No value is returned by this function. It is used to print model differences to the R console.
}
\description{
The \code{compareModels} function compares the output of two Mplus files and prints similarities and
differences in the model summary statistics and parameter estimates. Options are provided
for filtering out fixed parameters and nonsignificant parameters. When requested, \code{compareModels}
will compute the chi-square difference test for nested models (does not apply to MLMV, WLSM, and WLSMV
estimators, where DIFFTEST in Mplus is needed).
Model outputs to be compared can be full summaries and parameters (generated by \code{readModels}),
summary statistics only (\code{extractModelSummaries}), or parameters only (\code{extractModelParameters}).
}
\details{
The \code{show} parameter can be one or more of the following, which can be passed as a vector, such as c("equal", "pdiff").

\describe{
  \item{show}{
    \describe{
      \item{"all"}{Display all available model comparison. Equivalent to
        c("summaries", "equal", "diff", "pdiff", "unique").}
      \item{"summaries"}{Print a comparison of model summary statistics. Compares the following summary
        statistics (where available): c("Title", "Observations", "Estimator", "Parameters", "LL",
        "AIC", "BIC", "ChiSqM_Value", "ChiSqM_DF", "CFI", "TLI", "RMSEA", "SRMR", "WRMR")}
	 \item{"allsummaries"}{Prints a comparison of all summary statistics available in each model. May
        generate a lot of output.}
      \item{"equal"}{Print parameter estimates that are equal between models
        (i.e., \code{<= equalityMargin["param"]})}.
      \item{"diff"}{Print parameter estimates that are different between models
        (i.e., \code{> equalityMargin["param"]})}.
      \item{"pdiff"}{Print parameter estimates where the p-values differ between models
        (i.e., \code{> equalityMargin["pvalue"]})}.
      \item{"unique"}{Print parameter estimates that are unique to each model.}
    }
  }
}

The \code{sort} parameter determines the order in which parameter estimates are displayed. The following options are available:

\describe{
  \item{sort}{
    \describe{
      \item{"none"}{No sorting is performed, so parameters are output in the order presented in Mplus. (Default)}
      \item{"type"}{Sort parameters by their role in the model. This groups output by regression coefficient (ON),
        factor loadings (BY), covariances (WITH), and so on. Within each type, output is alphabetical.}
      \item{"alphabetical"}{Sort parameters in alphabetical order.}
      \item{"maxDiff"}{Sort parameter output by the largest differences between models (high to low).}
    }
  }
}
}
\examples{

# make me!!!
}
\author{
Michael Hallquist
}
\keyword{interface}

