% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortalityTable.ageShift.R
\name{generateAgeShift}
\alias{generateAgeShift}
\title{Generate data.frame containing age shifts for each birth year}
\usage{
generateAgeShift(initial = 0, YOBs = c(1900, 2100), step = -1)
}
\arguments{
\item{initial}{Age shift for the first birth year given in the \code{YOBs} vector}

\item{YOBs}{Vector of birth years in which the age shift changes by \code{step}. The last entry gives the first birth year that does not have any shift defined any more.}

\item{step}{How much the age shift changes in each year given in the \code{YOBs} vector}
}
\description{
Generate a dataframe suitable to be passed to the mortalityTable.ageShift
class.
}
\examples{
generateAgeShift(initial = 1, YOBs = c(1922, 1944, 1958, 1973, 1989, 2006, 2023, 2041, 2056))

}
