% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ageShift.R
\docType{methods}
\name{ageShift}
\alias{ageShift}
\alias{ageShift,mortalityTable-method}
\alias{ageShift,mortalityTable.ageShift-method}
\title{Return the age shift of the age-shifted life table given the birth year}
\usage{
ageShift(object, YOB = 1975, ...)

\S4method{ageShift}{mortalityTable}(object, YOB = 1975, ...)

\S4method{ageShift}{mortalityTable.ageShift}(object, YOB = 1975, ...)
}
\arguments{
\item{object}{The life table object (class inherited from mortalityTable)}

\item{YOB}{The birth year for which the age shift should be determined.}

\item{...}{Other parameters (currently unused)}
}
\description{
Return the age shift of the age-shifted life table given the birth year
}
\section{Methods (by class)}{
\itemize{
\item \code{mortalityTable}: Age shifts apply only to mortalityTagle.ageShift, so
all other tables return NA.

\item \code{mortalityTable.ageShift}: Return the age shift of the age-shifted life table
given the birth year
}}

\examples{
mortalityTables.load("Austria_Annuities")
ageShift(AVOe2005R.male.av, YOB=1910)
ageShift(AVOe2005R.male.av, YOB=1955)
ageShift(AVOe2005R.male.av, YOB=2010)
# A table with trend does NOT have any age shift, so NA is returned:
ageShift(AVOe2005R.male, YOB=1910)

}
