% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableHMD.R
\name{availableHMD}
\alias{availableHMD}
\title{Check Data Availability in HMD}
\usage{
availableHMD(username, password, ...)
}
\arguments{
\item{username}{Your HMD username. If you don't have one you can sign up
for free on Human Mortality Database website.}

\item{password}{Your HMD password.}

\item{...}{Other parameters to be passed in \code{ReadHMD} function.}
}
\value{
An \code{availableHMD} object.
}
\description{
The function returns information about available data in HMD (period life tables etc.), 
with the range of years covered by the life tables.
}
\examples{
\dontrun{
# This will take few seconds...
datainfo <- availableHMD(username = "your_username", 
                         password = "your_password")
datainfo
}
}
\seealso{
\code{\link{ReadHMD}}
}
