% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtp.R
\name{xtp}
\alias{xtp}
\title{Extrapolates non-extinct cohorts}
\usage{
xtp(path, max, country, year, sex, cmx)
}
\arguments{
\item{path}{path to the HMD folder for local access}

\item{max}{age at which the data should be right-censored}

\item{country}{HMD population letter code}

\item{year}{birth cohort for which the extrapolation should be performed}

\item{sex}{sex for which the extrapolation should be performed ("females" or "males")}

\item{cmx}{observed cohort mortality rates as given by a call to the \link{readHMD} function from the \pkg{HMDHFDplus} package}
}
\value{
Returns a vector of age-specific cohort mortality rates whose length depends on the \code{max} argument
}
\description{
This is an internal function of package \pkg{MortHump} which extrapolates cohort mortality rates for non-extinct cohorts. It is meant to be called from the \link{HMD2MH} function.
}
\details{
The extrapolation is currently only available for females and males, not for the total population.
The function uses the model of Hyndman & Ullah (see reference), a variant of the Lee-Carter model which, among others, takes into account more than one dimension of the single value decomposition.

The function first fits the model to period data, then extrapolates the age-specific death rates in the future, and reconstruct the cohort asdr by extracting the diagonal of the period asdr.
}
\references{
Hyndman, R. J., & Ullah, M. S. (2007). Robust forecasting of mortality and fertility rates: a functional data approach. Computational Statistics & Data Analysis, 51(10), 4942-4956.
}
\seealso{
\link{HMD2MH}, \link{fdm} from the \pkg{demography} package
}

