% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HCD2MH.r
\name{HCD2MH}
\alias{HCD2MH}
\title{Format data from the Human Cause-of-Death Database for use in the MortHump package}
\usage{
HCD2MH(country, year, sex, list, unabr = FALSE, path)
}
\arguments{
\item{country}{HCD population letter code}

\item{year}{year for which the data is required}

\item{sex}{sex for which the data is required ("females", "males" or "total")}

\item{list}{cause-of-death classification ("short", "interm" or "full")}

\item{unabr}{should the data be unabridged into single-year values}

\item{path}{path to the HCD folder for local access}
}
\value{
HCD2MH returns a list of six elements:
 \describe{
   \item{mxc}{a matrix of cause- and age-specific death rates (age in rows, causes in columns)}
   \item{dxc}{a matrix of cause- and age-specific death counts (age in rows, causes in columns)}
   \item{nx}{a vector of age-specific exposures}
   \item{x}{a vector of mid-point for each age interval}
   \item{age}{a character vector of age labels}
   \item{inter}{a matrix containing the endpoints of the age intervals}
   \item{lab}{a character vector of short names for the causes of death}
 }
}
\description{
This is a data grabber for the Human Cause-of-death database that select and format age- and cause-specific death counts, exposures, rates and cause-of-death labels.
It formats the data so that they can be properly used by \code{codhump} function.
}
\details{
This function assumes that all the HCD data are stored into a single folder, containing itself country-specific folders.
To constitute this folder, download the zipped \href{http://www.causesofdeath.org/cgi-bin/datazip.php}{datasets by country}, and unzip the country folders.
The list of available countries and period coverage can be found on the \href{http://www.causesofdeath.org/cgi-bin/data.php}{HCD website}.

The \href{http://www.causesofdeath.org/docs/interm_list.pdf}{Intermediate} and \href{http://www.causesofdeath.org/docs/short_list.pdf}{short} cause-of-death classifications can be found on the HCD website.
The full list depends on each country and can be found on the country pages.
}
\references{
Human Cause-of-Death Database. French Institute for Demographic Studies (France) and Max Planck Institute for Demographic Research (Germany). Available at \url{www.causeofdeath.org} (data downloaded in May 2016).
}
\seealso{
\link{codhump}
}

