% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_tac}
\alias{coo_tac}
\title{Calculates the total absolute curvature of a shape}
\source{
Siobhan Braybrook.
}
\usage{
coo_tac(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or any \code{Coo}}
}
\value{
\code{numeric} for a single shape and for \code{Coo}
}
\description{
Calculated using the sum of the absolute value of the second derivative of
the \code{smooth.spline} prediction for each defined point.
}
\examples{
coo_tac(bot[1])

bot \%>\%
    slice(1:3) \%>\%  # for speed sake only
    coo_tac
}
\seealso{
Other coo_ descriptors: 
\code{\link{coo_angle_edges}()},
\code{\link{coo_angle_tangent}()},
\code{\link{coo_area}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_chull}()},
\code{\link{coo_circularity}()},
\code{\link{coo_convexity}()},
\code{\link{coo_eccentricity}},
\code{\link{coo_elongation}()},
\code{\link{coo_length}()},
\code{\link{coo_lw}()},
\code{\link{coo_rectangularity}()},
\code{\link{coo_rectilinearity}()},
\code{\link{coo_scalars}()},
\code{\link{coo_solidity}()},
\code{\link{coo_width}()}
}
\concept{coo_ descriptors}
