% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-polynomials.R
\name{npoly}
\alias{npoly}
\alias{npoly.default}
\alias{npoly.Opn}
\title{Calculate natural polynomial fits on open outlines}
\usage{
npoly(x, ...)

\method{npoly}{default}(x, degree, ...)

\method{npoly}{Opn}(x, degree, baseline1 = c(-0.5, 0), baseline2 = c(0.5,
  0), nb.pts = 120, ...)
}
\arguments{
\item{x}{a matrix (or a list) of (x; y) coordinates or an \link{Opn} object}

\item{...}{useless here}

\item{degree}{polynomial degree for the fit (the Intercept is also returned)}

\item{baseline1}{numeric the \eqn{(x; y)} coordinates of the first baseline
by default \eqn{(x= -0.5; y=0)}}

\item{baseline2}{numeric the \eqn{(x; y)} coordinates of the second baseline
by default \eqn{(x= 0.5; y=0)}}

\item{nb.pts}{number of points to sample and on which to calculate polynomials}
}
\value{
when applied on a single shape, a list with components:
\itemize{
 \item \code{coeff} the coefficients (includint the intercept)
 \item \code{ortho} whether orthogonal or natural polynomials were fitted
 \item \code{degree} degree of the fit (could be retrieved through \code{coeff} though)
 \item \code{baseline1} the first baseline point (so far the first point)
 \item \code{baseline2} the second baseline point (so far the last point)
 \item \code{r2} the r2 from the fit
 \item \code{mod} the raw lm model
}

otherwise, an \link{OpnCoe} object.
}
\description{
Calculates natural polynomial coefficients,
through a linear model fit (see \link{lm}), from a matrix of (x; y) coordinates
or an \link{Opn} object
}
\examples{
data(olea)
o <- olea[1]
op <- opoly(o, degree=4)
op
# shape reconstruction
opi <- opoly_i(op)
lines(opi, col='red')
# R2 for degree 1 to 10
r <- numeric()
for (i in 1:10) { r[i] <- npoly(o, degree=i)$r2 }
plot(2:10, r[2:10], type='b', pch=20, col='red', main='R2 / degree')
}
\seealso{
Other polynomials: \code{\link{opoly_i}},
  \code{\link{opoly}}
}
