% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-out-rfourier.R
\name{rfourier_i}
\alias{rfourier_i}
\title{Inverse radii variation Fourier transform}
\usage{
rfourier_i(rf, nb.h, nb.pts = 120)
}
\arguments{
\item{rf}{A \code{list} with \code{ao}, \code{an} and \code{bn} components,
typically as returned by \code{rfourier}.}

\item{nb.h}{\code{integer}. The number of harmonics to calculate/use.}

\item{nb.pts}{\code{integer}. The number of points to calculate.}
}
\value{
A list with components: \item{x }{\code{vector} of
\code{x}-coordinates.} \item{y }{\code{vector} of \code{y}-coordinates.}
\item{angle}{\code{vector} of angles used.} \item{r}{\code{vector} of radii
calculated.}
}
\description{
\code{rfourier_i} uses the inverse radii variation transformation to
calculate a shape, when given a list with Fourier coefficients, typically
obtained computed with \link{rfourier}.
}
\details{
See the JSS paper for the maths behind.
}
\note{
Directly borrowed for Claude (2008), and called \code{ifourier1} there.
}
\examples{
data(bot)
coo <- coo_center(bot[1]) # centering is almost mandatory for rfourier family
coo_plot(coo)
rf  <- rfourier(coo, 12)
rf
rfi <- rfourier_i(rf)
coo_draw(rfi, border='red', col=NA)

}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
\seealso{
Other rfourier: \code{\link{rfourier_shape}},
  \code{\link{rfourier}}
}

