% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiregSingleIndex.R
\name{sinvreg}
\alias{sinvreg}
\title{Dimension Reduction Based on Sliced Inverse Regression}
\usage{
sinvreg(x, y, nslice = NULL)
}
\arguments{
\item{x}{an n by p matrix of observations where n is the number of observations and
p is the number of explanatory variables.}

\item{y}{an n-dimentionsl vector of response values.}

\item{nslice}{number of slices. Default is 10.}
}
\value{
A list containing the following elements:
\item{direction}{direction vector.}
\item{reducedx}{reduced x.}
\item{eigenvalue}{eigenvalues for reduced x.}
\item{nobs}{number of observations within each slice.}
}
\description{
`sinvreg' is used in the examples for the \code{\link{semimrFull}} and \code{\link{semimrOne}} functions to obtain
initial values based on sliced inverse regression (Li, 1991).
}
\examples{
# See examples for the 'semimrFull' function.
}
\references{
Li, K. C. (1991). Sliced inverse regression for dimension reduction.
Journal of the American Statistical Association, 86(414), 316-327.
}
\seealso{
\code{\link{semimrFull}}, \code{\link{semimrOne}}
}
